const { check, validationResult } = require('express-validator');
const message = require('../../constants/message');
const response = require('../../constants/response');

/**
 * Validates create new RPC request
 */
exports.addRPC = [
    check('first_name')
        .exists()
        .withMessage('MISSING')
        .not()
        .isEmpty()
        .withMessage(message.IS_EMPTY),
    check('last_name')
        .exists()
        .withMessage('MISSING')
        .not()
        .isEmpty()
        .withMessage(message.IS_EMPTY),
    check('email')
        .exists()
        .withMessage('MISSING')
        .not()
        .isEmpty()
        .withMessage(message.IS_EMPTY)
        .isEmail()
        .withMessage(message.EMAIL_NOT_VALID),
    check('password')
        .exists()
        .withMessage('MISSING')
        .not()
        .isEmpty()
        .withMessage(message.IS_EMPTY)
        .isLength({
            min: 5
        })
        .withMessage('PASSWORD_TOO_SHORT_MIN_5'),
    check('company_name')
        .exists()
        .withMessage('MISSING')
        .not()
        .isEmpty()
        .withMessage(message.IS_EMPTY)
        .trim(),
    check('mobile_no')
        .exists()
        .withMessage('MISSING')
        .not()
        .isEmpty()
        .withMessage(message.IS_EMPTY)
        .trim(),
    check('city')
        .exists()
        .withMessage('MISSING')
        .not()
        .isEmpty()
        .withMessage(message.IS_EMPTY)
        .trim(),
    check('zip_code')
        .exists()
        .withMessage('MISSING')
        .not()
        .isEmpty()
        .withMessage(message.IS_EMPTY)
        .trim(),
    check('state')
        .exists()
        .withMessage('MISSING')
        .not()
        .isEmpty()
        .withMessage(message.IS_EMPTY)
        .trim(),
    check('permissions')
        .exists()
        .withMessage('MISSING')
        .not()
        .isEmpty()
        .withMessage(message.IS_EMPTY),
    (req, res, next) => {
        const errors = validationResult(req);
        if (!errors.isEmpty()) {
            return response.errorMessageResponse(res, 406, errors.array());
        } else {
            next();
        }
    }
]

