const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { StaticPages } = require("../../models");
const db = require("../../services/db");

/**
* Creates a new OwnerType in database
* @param {Object} req - request object
*/
const add = async (req, res) => {
    const { building_owner_name, description } = req.body;
    const documents = { path: "public/uploads/" + req.file.filename, filename: req.file.filename, type: "images" };
    const building_owner = new StaticPages({
        building_owner_name,
        description,
        documents
    });
    try {
        const saveBuildingOwnerStatic = await building_owner.save();
        return response.successResponse(
            res,
            200,
            saveBuildingOwnerStatic,
            MESSAGE.STATIC_CONTENT_ADD_SUCCESS
        );
    } catch (e) {
        console.log(e);
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const update = async (req, res) => {
    const { building_owner_name, description } = req.body;
    const documents = { path: "public/uploads/" + req.file.filename, filename: req.file.filename, type: "images" };

    try {
        var result = await StaticPages.findByIdAndUpdate(
            (_id = req.body._id),
            {
                building_owner_name,
                description,
                documents,
                updatedBy: req.id,
            },
            { new: true }
        );

        if (result) {
            return response.successResponse(
                res,
                200,
                result,
                MESSAGE.STATIC_CONTENT_UPDATE_SUCCESS
            );
        } else {
            return response.badRequest(res, 400, MESSAGE.STATIC_CONTENT_NOT_FOUND);
        }
    } catch (e) {
        console.log(e);
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

/**
* Get All Material from database by role
* @param {string} req - object
*/
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        return response.successResponse(res, 200, await db.getItems(req, StaticPages, query), MESSAGE.STATIC_CONTENT_VIEW_DATA);
    } catch (error) {
        console.log(error);
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}


const deleteStatic = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, StaticPages)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.Owner_Type_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

module.exports = {
    viewAll,
    add,
    update,
    deleteStatic,
}