const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { RoofType } = require("../../models");
const db = require("../../services/db");

/**
 * Creates a new RoofingType in database
 * @param {Object} req - request object
 */
const add = async (req, res) => {
  const {
    name,
    description,
    price
  } = req.body;
  try {
    const roofType = new RoofType({
      name,
      description,
      price,
      createdBy: req.id,
    });
    const SaveRoofType = await roofType.save();
    return response.successResponse(res, 200, SaveRoofType, MESSAGE.ROOF_ADD_SUCCESS);
  } catch (e) {
    console.log(e);
    return response.somethingErrorMsgResponse(res, 500, e);
  }
};

/**
 * Updates an RoofingType in database by id
 * @param {string} id - item id
 * @param {Object} req - request object
 */
const update = async (req, res) => {
  const { name, description, price, status } = req.body;
  try {
    var result = await RoofType.findByIdAndUpdate((_id = req.body._id), {
      name,
      description,
      price,
      status,
      updatedBy: req.id
    });
    if (result) {
      return response.successResponse(res, 200, result, MESSAGE.ROOF_UPDATE_SUCCESS);
    } else {
      return response.badRequest(res, 400, MESSAGE.ROOF_UPDATE_FAILD);
    }
  } catch (e) {
    return response.somethingErrorMsgResponse(res, 500, e);
  }
};

/**
 * Get All RoofType from database
 * @param {string} req - object
 */
const viewAll = async (req, res) => {
  try {
    let query = await db.checkQueryString(req.query)
    return response.successResponse(res, 200, await db.getItems(req, RoofType, query), MESSAGE.ROOf_VIEW_DATA);
  } catch (error) {
    return response.somethingErrorMsgResponse(res, 500, error);
  }
};


/**
* Get one RoofType from database by id
* @param {string} id - id
*/
const viewOne = async (req, res) => {
  const roofing_id = req.query.id;
  try {
    const roofing = await RoofType.findOne({ _id: roofing_id }).exec();
    return response.successResponse(res, 200, roofing, MESSAGE);
  }
  catch (e) {
    return response.somethingErrorMsgResponse(res, 500, e);
  }
}

/**
* Delete one Roof from database by id
* @param {string} id - user id
*/
const deleteRoofType = async (req, res) => {
  try {
    const result = await db.softDeleteItems(req.params.id, RoofType)
    if (result) {
      return response.successResponse(res, 200, {}, MESSAGE.ROOf_DELETE_SUCCESS);
    } else {
      return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
    }
  } catch (e) {
    return response.somethingErrorMsgResponse(res, 500, e);
  }
}

/**
* toggle change for Roof Type from database by id
* @param {string} id - rooftype id
*/
const updateRoofStatus = async (req, res) => {
  try {
    var result = await RoofType.findByIdAndUpdate({ _id: req.body.id }, { $set: { status: JSON.parse(req.body.status) } }, { new: true });
    if (result) {
      return response.successResponse(res, 200, result, MESSAGE.ROOF_UPDATE_SUCCESS);
    } else {
      return response.badRequest(res, 400, MESSAGE.ROOF_UPDATE_FAILD);
    }
  } catch (e) {
    return response.somethingErrorMsgResponse(res, 500, e);
  }
};

module.exports = {
  add,
  update,
  viewAll,
  viewOne,
  deleteRoofType,
  updateRoofStatus
};
