const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { ProjectBidForms } = require("../../models");
const db = require("../../services/db");

// Create and Save a new bid form template
const create = async (req, res) => {
    // Validate request
    if (!req.body.project_id ) {
        return response.errorMessageResponse(res, 500, MESSAGE.PROJECT_ID_REQUIRED);
      }
      if (!req.body.line_items) {
        return response.badRequest(res, 400, MESSAGE.LINE_ITEMS_REQUIRED);
      }
      if (req.body.line_items && req.body.line_items.length == 0) {
        return response.badRequest(res, 400, MESSAGE.EMPTY_LINEITEMS_CONTENT_ERROR);
      }
      const bidTemplateExist = await ProjectBidForms.find({ project_id : req.body.project_id });
      // check if bid form already created for a given project
      if (bidTemplateExist.length > 0) {
          return response.errorMessageResponse(res, 500, MESSAGE.BID_FORM_TEMPLATE_EXIST)
        }
    // Create a bid form template
    const bidFormTemplate = new ProjectBidForms({
        project_id: req.body.project_id , 
        line_items: req.body.line_items ? req.body.line_items : []
    });

    // Save record in the database
    bidFormTemplate.save()
    .then(data => {
        return response.successResponse(res, 200, data, MESSAGE.BID_FORM_ADD_SUCCESS);
    }).catch(err => {
        return response.errorMessageResponse(res, 500, err);
    });
};

// Get a bid form of a project by project id
const getProjectBidForm = async(req, res) => {
    try {
        const page = await db.getItemByParams(ProjectBidForms, {project_id:req.params.project_id});
        return response.successResponse(res, 200, page, MESSAGE.BID_FORM_LIST_SUCCESS);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};


// Update Project Bid form Template

const updateBidForm = async (req, res) => {
   // Validate request
    if (!req.body.line_items) {
        return response.badRequest(res, 400, MESSAGE.LINE_ITEMS_REQUIRED);
    }
    if (req.body.line_items && req.body.line_items.length == 0) {
        return response.badRequest(res, 400, MESSAGE.EMPTY_LINEITEMS_CONTENT_ERROR);
    }
    const payload = {
        line_items: req.body.line_items ? req.body.line_items : []
    }
    let results = await db.updateItem(req.body._id, ProjectBidForms, payload)

    if (results) {
        return response.successResponse(res, 200, results, MESSAGE.BID_FORM_TEMPLATE_UPDATE_SUCCESS);
    } else {
        return response.badRequest(res, 400, MESSAGE.BID_FORM_TEMPLATE_UPDATE_FAILURE);
    }
};

module.exports = {
   create,
   getProjectBidForm,
   updateBidForm
}
