const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const EMAIL_TEMPLATES = require("../../constants/email_templates_id");
const mail = require("../../utils/notify");
const { Project, File, User, Building, QuestionAnswers, Media, Bid, MaterialType, RValue, WindUplift, RoofType, NewRoofType, NotificationsSettings } = require("../../models");
const moment = require("moment");
var mongoSanitize = require('mongo-sanitize');
const db = require("../../services/db")
const { removeEmptyKeys } = require("../../services/utils");
const mediaUtils = require("../../utils/unlinkMedia");
const util = require('util');
const _ = require('lodash');
const pushNotification = require("../../push_notification");
/**
 * Creates a new Project in database
 * @param {Object} req - request object
 */
const add = async (req, res) => {
    try {
        let params = removeEmptyKeys(req.body)
        const payload = _.cloneDeep(req.body);
        payload.selectedMenuItems = (payload.selectedMenuItems && typeof (payload.selectedMenuItems) == 'string') ? JSON.parse(req.body.selectedMenuItems) : [];
        payload.projectDescription = (payload.projectDescription && typeof (payload.projectDescription) == 'string') ? JSON.parse(req.body.projectDescription) : [];
        
        payload.allowedBid = (payload.allowedBid && typeof (payload.allowedBid) == 'string') ? JSON.parse(req.body.allowedBid) : [];
        payload.manufacturers = (payload.manufacturers && typeof (payload.manufacturers) == 'string') ? JSON.parse(req.body.manufacturers) : [];

        let results = await db.insertItem(Project, payload)
        let media = [];
        const mediaRootPath = "public/uploads/" + req.body.ownerId + '/buildings/' + req.body.buildingId + '/projects/';
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    media.push({
                        path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                        filename: mediaFile.filename,
                        ref_id: results._id,
                        type: mediaFile.fieldname
                    });
                })

            } else {
                console.log("Else condition block")
            }
        })
        // check if add project success or not.
        if (results) {
            // now perform media files addition to DB after successfull add project operation
            // store all images,documents and videos
            await Media.insertMany(media);
            const result = await db.getItemByParams(Project, { _id: results._id }, [{ path: "media" }])

            return response.successResponse(res, 200, result, MESSAGE.PROJECT_ADD_SUCCESS)
        } else {
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return response.badRequest(res, 400, MESSAGE.PROJECT_NOT_FOUND);
        }
    } catch (e) {
        // delete all uploaded project media files
        const mediaRootPath = "public/uploads/" + req.body.ownerId + '/buildings/' + req.body.buildingId + '/projects/';
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })
        return response.errorMessageResponse(res, 500, e);
    }
}

/**
 * @description details of all required fields from database.
 * @param {*} req 
 * @param {object} res 
 * @returns 
 */
const details = async (req, res) => {
    try {
        let results = {
            rValue: await db.getItemsByParams(RValue),
            windUplift: await db.getItemsByParams(WindUplift),
            roofSystem: await db.getItemsByParams(RoofType),
            NewRoofSystemType: await db.getItemsByParams(NewRoofType),
            materialType: await db.getItemsByParams(MaterialType),
            owner: await db.getItemsByParams(User, { role: "OWNER" }, [{ path: "buildings" }]),
            manufacturer: await db.getItemsByParams(User, { role: "MANUFACTURER" })
        }
        return response.successResponse(res, 200, results, MESSAGE.PROJECT_VIEW_DATA)
    } catch (e) {
        return response.errorMessageResponse(res, 500, e);
    }
}

/**
 * Updates an Project in database by id
 * @param {string} id - item id
 * @param {Object} req - request object
 */
const update = async (req, res) => {
    try {

        const payload = _.cloneDeep(req.body);
        const oldDetails = await db.getItem(req.body._id, Project);
        payload.selectedMenuItems = (payload.selectedMenuItems && typeof (payload.selectedMenuItems) == 'string') ? JSON.parse(req.body.selectedMenuItems) : [];
        payload.projectDescription = (payload.projectDescription && typeof (payload.projectDescription) == 'string') ? JSON.parse(req.body.projectDescription) : [];
        
        payload.allowedBid = (payload.allowedBid && typeof (payload.allowedBid) == 'string') ? JSON.parse(req.body.allowedBid) : [];
        payload.manufacturers = (payload.manufacturers && typeof (payload.manufacturers) == 'string') ? JSON.parse(req.body.manufacturers) : [];

        // const contractors = await db.getItemsByParams(User,{role:"CONTRACTOR"})
        // var contractorsIds = await contractors.map(function (userDetails) {
        //     return userDetails.id;
        //   });
        // var manufacturersIds = await (payload.manufacturers).map(function (userDetails) {
        // return userDetails.value;
        // });
        // const toUsersId = [...contractorsIds, ...manufacturersIds];
        // const NotificationEnabled = await NotificationsSettings.findOne({type:'PROJECT_ACTIVATION', enabled:true}).exec();
        // console.log(contractorsIds);
        // console.log("manufacturer", manufacturersIds);
        // console.log("user ids array", toUsersId)
        // // template = NotificationEnabled.notification_content.replace(/{([^{}]+)}/g, function(keyExpr, key) {
        // //     console.log("key", key)
        // //     return 'RAM RAM' || "";
        // //   });
        // // pushNotification.sendNotification(req, res ,  req.body , NotificationEnabled);
        // return res.send(contractorsIds);


        let results = await db.updateItem(req.body._id, Project, payload)
        let media = [];

        const mediaRootPath = "public/uploads/" + req.body.ownerId + '/buildings/' + req.body.buildingId + '/projects/';
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    media.push({
                        path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                        filename: mediaFile.filename,
                        ref_id: results._id,
                        type: mediaFile.fieldname
                    });
                })

            } else {
                console.log("Else condition block")
            }
        })

        if (results) {
            // store all images,documents and videos
            await Media.insertMany(media);
            // Remove all the removed media from directory and Media Collection
            if (req.body.removed_items) {
                const filesTobeRemoved = JSON.parse(req.body.removed_items);
                await filesTobeRemoved.forEach(element => {
                    mediaUtils.unlink(element.path);
                    // delete record from Media collection
                    Media.delete({ _id: element._id, filename: element.filename, ref_id: element.ref_id }).exec();
                });
            }
            const result = await db.getItemByParams(Project, { _id: results._id }, [{ path: "media" }]);
            const NotificationEnabled = await NotificationsSettings.findOne({ type: 'PROJECT_ACTIVATION', enabled: true }).exec();
            console.log("oldDetails.status", oldDetails.status)
            console.log("req.body.status", typeof (req.body.status))
            console.log("NotificationEnabled", NotificationEnabled)
            if ((oldDetails.status != req.body.status) && (req.body.status === true) && NotificationEnabled) {
                // create Notification and send to Manufaturers and associted Contractars
                const contractors = await db.getItemsByParams(User, { role: "CONTRACTOR" })
                var contractorsIds = await contractors.map(function (userDetails) {
                    return userDetails.id;
                });
                var manufacturersIds = await (payload.manufacturers).map(function (userDetails) {
                    return userDetails.value;
                });
                const toUsersId = [...contractorsIds, ...manufacturersIds];

                await pushNotification.sendNotification(req, res, toUsersId, NotificationEnabled, req.body);
            }
            return response.successResponse(res, 200, result, MESSAGE.PROJECT_UPDATE_SUCCESS);

        } else {
            // remove all recently uploaded images from directory
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return response.badRequest(res, 400, MESSAGE.PROJECT_NOT_FOUND);
        }
    } catch (e) {
        // delete all uploaded project media files from directory
        const mediaRootPath = "public/uploads/" + req.body.ownerId + '/buildings/' + req.body.buildingId + '/projects/';
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })
        return response.errorMessageResponse(res, 500, e);
    }
}

/**
 * Get All Project from database 
 * @param {string} req - project 
 */
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        // req.populate = [{ path: 'media', match: { deleted: false } }, { path: 'ownerId' }, { path: "buildingId",match: {"buildingId.city" :'nagpurn'} }, { path: "inspection" }]
        // if(req.query && req.query.city){
        //     req.populate = [{ path: 'media', match: { deleted: false } }, { path: 'ownerId' }, { path: "buildingId", match: {"city" : req.query.city} }, { path: "inspection" }]
        // }
        // else if(req.query && req.query.state){
        //     req.populate = [{ path: 'media', match: { deleted: false } }, { path: 'ownerId' }, { path: "buildingId", match: {"state" : req.query.state} }, { path: "inspection" }]
        // }else{
        //     req.populate = [{ path: 'media', match: { deleted: false } }, { path: 'ownerId' }, { path: "buildingId"}, { path: "inspection" }]
        // }
        req.populate = [{ path: 'media', match: { deleted: false } }, { path: 'ownerId' }, { path: "buildingId" }, { path: "inspection" }]
        return response.successResponse(res, 200, await db.getItems(req, Project, query), MESSAGE.PROJECT_VIEW_DATA);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

/**
 * Get one Project from database by id
 * @param {string} id - user id
 */
const viewOne = async (req, res) => {
    try {
        const project = await db.getItemWithPopulate(req.query.id, Project,
            [{ path: 'media', match: { deleted: false } }, { path: 'ownerId' }, { path: "buildingId" }, { path: "inspection" }, { path: "existingRoof_type" },
            { path: "material_type" }, { path: "wind_uplift" }, { path: "r_value" }, { path: "newRoof_type" }, { path: "associatedEstimatorAssistance" }])
        return response.successResponse(res, 200, project, MESSAGE.PROJECT_VIEW_DATA);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
 * Delete one Project from database by id
 * @param {string} id - user id
 */
const deleteProject = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, Project)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.PROJECT_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

const addUpdateEstimatorAssitance = async (req, res) => {
    try {

        const payload = _.cloneDeep(req.body);
        payload.associatedEstimatorAssistance = (payload.associatedEstimatorAssistance) ? req.body.associatedEstimatorAssistance : [];
        console.log("payload", payload)
        let results = await db.updateItem(req.body._id, Project, payload)

        if (results) {
            return response.successResponse(res, 200, results, MESSAGE.PROJECT_UPDATE_SUCCESS);

        } else {
            return response.badRequest(res, 400, MESSAGE.PROJECT_NOT_FOUND);
        }
    } catch (e) {
        return response.errorMessageResponse(res, 500, e);
    }
}

const changeBidPeriod = async (req, res) => {
    const { bid_start_date, bid_end_date, project_id } = req.body;
    try {
        var result = await Project.findByIdAndUpdate((_id = project_id), {
        bid_start_date: bid_start_date,
        bid_end_date: bid_end_date,
        });
        if (result) {
        // send Email Notifications to Bidders and Manufacturers
        const projectDetails = await Project.findOne({ _id: questionDetails.project_id })
        .populate([{path:'manufacturers',select:['first_name', 'last_name', 'email']}])
        .populate([{path:'participating_bidders',select:['first_name', 'last_name', 'email']}]);
        var participatingBiddersEmails = await (projectDetails.participating_bidders).map(function (details) {
            return details['email'];
        });
        var manufacturersEmails = await (projectDetails.manufacturers).map(function (details) {
            return details['email'];
        });
        var senderEmails = [...participatingBiddersEmails , ...manufacturersEmails] ;

        const emailData = {
            msg: {
              to: senderEmails, // Notify to all bidders and manufacturers on bid period change
              from: 'Winston@roofingprojects.com', // Use the email address or domain you verified above
              template_id: EMAIL_TEMPLATES.BID_PERIOD_CHANGED_NOTIFY_BIDDERS_TEMPLATE_ID,
              dynamic_template_data:{
                "project_name": projectDetails ? projectDetails.project_title : 'Project Details Not Available',
                "bid_start_date": projectDetails ? projectDetails.bid_start_date : "N/A",
                "bid_end_date": projectDetails ? projectDetails.bid_end_date : "N/A",
                "project_status": projectDetails.project_status
                }
            }
          };
          mail.sendMailWithTemplate(emailData); // to all Participating Bidders
        return response.successResponse(
            res,
            200,
            result,
            MESSAGE.BID_UPDATE_SUCCESS
        );
        } else {
        return response.badRequest(res, 400, MESSAGE.BID_NOT_FOUND);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
    };



module.exports = {
    add,
    viewAll,
    viewOne,
    update,
    deleteProject,
    details,
    addUpdateEstimatorAssitance,
    changeBidPeriod
}