const { Project, opportunityPayment, User } = require("../../models")
const db = require("../../services/db");
const MESSAGE = require("../../constants/message")
const response = require("../../constants/response")
const stripe = require('stripe')(process.env.STRIPE_SECURITY_KEY);
const { getLoggedInUser } = require("../../utils/jwtToken");

const makePayments = async (req, res) => {
  try {
    const obj = { _id: req.body.id };
    const authHeader = req.headers.authorization;
    let token = authHeader.split("Bearer ")[1];
    const loggedInuser = await getLoggedInUser(token);
    const userId = loggedInuser.payload._id;
    // check if user already purchased this project or not.
    const userHasAlreadyPurchased = await opportunityPayment.find({ purchasedBy: userId, project_id: req.body.id, mode: 'payment' });
    // check if user already purchased thie project
    if (userHasAlreadyPurchased.length > 0) {
      return response.errorMessageResponse(res, 500, MESSAGE.ALREADY_PURCHASED)
    }
    const result = await Project.findOne(obj);
    if (result) {
      const session = await stripe.checkout.sessions.create({
        payment_method_types: ["card"],
        client_reference_id: result._id + "_" + userId,
        metadata: {
          project_id: result.id,
          user_id: userId
        },
        success_url: process.env.PAYMENT_SUCCESS_URL,
        cancel_url: process.env.PAYMENT_FAILED_URL,
        line_items: [
          {
            price_data: {
              currency: "usd",
              product_data: {
                name: "Bidding Opportunity Payment",
              },
              unit_amount: result.bidder_fee,
            },
            quantity: 1,
          },
        ],
        mode: 'payment',
      });
      return response.successResponse(res, 200, session, "payment Initiate Success");
    } else {
      return response.somethingErrorMsgResponse(res, 500, MESSAGE.PROJECT_NOT_FOUND);
    }

  } catch (error) {
    return response.somethingErrorMsgResponse(res, 500, error);
  }
}

let endpointSecret;
const onTransactionComplete = async (req, res) => {
  console.log("payment callback Body data")

  const sig = req.headers['stripe-signature'];
  console.log("webhook end point called")
  let eventType;
  let data;
  if (endpointSecret) {
    let event;

    try {
      event = stripe.webhooks.constructEvent(req.body, sig, endpointSecret);
      console.log(`Webhook Verified: ${data}`)
    } catch (err) {
      console.log(`Webhook Error: ${err.message}`)
      res.status(400).send(`Webhook Error: ${err.message}`);
      return;
    }
    data = event.data.object;
    eventType = event.type;
  } else {
    data = req.body.data.object;
    eventType = req.body.type;
  }


  // Handle the event
  switch (eventType) {
    case 'payment_intent.succeeded':
      const paymentIntent = data;
      // Then define and call a function to handle the event payment_intent.succeeded
      console.log("Payment Intent success:", data)
      // Return a 200 response to acknowledge receipt of the event
      res.send("On Transaction complete Method");
      break;
    case 'checkout.session.completed':
      // const paymentIntent = event.data.object;
      // Then define and call a function to handle the event payment_intent.succeeded
      console.log("Checkout success:", data)
      // Create Transaction Payload to save into Transaction DB.
      const payload = {
        project_id: data.metadata.project_id,
        session_id: data.id,
        purchasedBy: data.metadata.user_id,
        transaction_id: data.payment_intent,
        client_reference_id: data.client_reference_id,
        amount: data.amount_total,
        currency: data.currency,
        mode: data.mode,
        payment_status: data.payment_status,
        metadata: data.metadata,
        gateway_response: data
      };

      // Record Transaction Data
      const transaction = new opportunityPayment(payload);

      // Save payment transaction history in the database
      transaction.save()
        .then(async data => {
          // save transaction id to projects collection
          const projectData = await Project.findOne({ _id: data.metadata.project_id });
          projectData.transaction_ids.push(data._id);
          console.log("project Data", projectData)
          let results = await db.updateItem(data.metadata.project_id, Project, projectData)
          const userData = await User.findOne({ _id: data.metadata.user_id });
          userData.purchased_opportunities.push(data.metadata.project_id);
          console.log("user Data", userData)
          let userResult = await db.updateItem(data.metadata.user_id, User, userData)
          // Return a 200 response to acknowledge receipt of the event
          res.send({ data: results, message: "On Transaction complete Method" });
        }).catch(err => {
          return res.status(500).send({
            is_error: true,
            message: err.message || "Some error occurred while recording transaction data."
          });
        });
      break;
    // ... handle other event types
    default:
      console.log(`Unhandled event type ${eventType}`);
      // Return a 200 response to acknowledge receipt of the event
      res.send("On Transaction complete Method");
  }


};

const getMyTransactionDetails = async (req, res) => {
  try {
    const authHeader = req.headers.authorization;
    let token = authHeader.split("Bearer ")[1];
    const loggedInuser = await getLoggedInUser(token);
    const userId = loggedInuser.payload._id;
    const transactionDetails = await opportunityPayment.findOne({project_id: req.body.project_id,session_id: req.body.session_id, purchasedBy: userId });
    if (transactionDetails){
      return response.successResponse(res, 200, transactionDetails, "Transaction Details reterived successfully.");
    }
    else {
      return response.successResponse(res, 200, {}, "Error while retering your transaction details.");
    }

  } catch (error) {
    console.log(error)
    return response.somethingErrorMsgResponse(res, 500, error);
  }
}
module.exports = {
  makePayments,
  onTransactionComplete,
  getMyTransactionDetails
};
