const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { OwnerType } = require("../../models");
const db = require("../../services/db");

/**
* Creates a new OwnerType in database
* @param {Object} req - request object
*/
const add = async (req, res) => {
    const { owner_type_name, description } = req.body;

    const ownerType = new OwnerType({
        owner_type_name,
        description
    });
    try {
        const saveOwnerType = await ownerType.save();
        return response.successResponse(
            res,
            200,
            saveOwnerType,
            MESSAGE.Owner_Type_ADD_SUCCESS
        );
    } catch (e) {
        console.log(e);
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const update = async (req, res) => {
    const { owner_type_name, description } = req.body;

    try {
        var result = await OwnerType.findByIdAndUpdate(
            (_id = req.body._id),
            {
                owner_type_name,
                description,
                updatedBy: req.id,
            },
            {new:true}
        );

        if (result) {
            return response.successResponse(
                res,
                200,
                result,
                MESSAGE.Owner_Type_UPDATE_SUCCESS
            );
        } else {
            return response.badRequest(res, 400, MESSAGE.Owner_Type_NOT_FOUND);
        }
    } catch (e) {
        console.log(e);
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

/**
* Get All Material from database by role
* @param {string} req - object
*/
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        return response.successResponse(res, 200, await db.getItems(req, OwnerType, query), MESSAGE.Owner_Type_VIEW_DATA);
    } catch (error) {
        console.log(error);
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}


const deleteOwnerType = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, OwnerType)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.Owner_Type_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const viewOwnerType = async (req, res) => {
    const OWNER_ID = req.query.id;
    try {
      const owner = await OwnerType.findOne({ _id: OWNER_ID }).exec();
      return response.successResponse(res, 200, owner);
    } catch (e) {
      return response.somethingErrorMsgResponse(res, 500, e);
    }
  };


const updateOwnerTypestatus = (req, res) => {
    const OWNER_ID = req.body.id;
    OwnerType.findOne({ _id: OWNER_ID }, (err, result) => {
      result.status = !result.status;
      result.save((err, updatedOwnerType) => {
        if (!err) {
          return response.successResponse(res, 200, { status: result.status },  MESSAGE.Owner_Type_STATUS_UPDATED);
        } else {
          return response.somethingErrorMsgResponse(res, 500, error);
        }
      });
    });
  };

module.exports = {
    viewAll,
    add,
    update,
    deleteOwnerType,
    viewOwnerType,
    updateOwnerTypestatus
}