const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { Project, User } = require("../../models");
const db = require("../../services/db")
const { getLoggedInUser } = require("../../utils/jwtToken");
const bcrypt = require("bcryptjs");
const mail = require("../../../MEAN-Roofing/utils/notify");

/**
 * Get All Project from database 
 * @param {string} req - project 
 */
const myProjects = async (req, res) => {
    try {
        const authHeader = req.headers.authorization;
        let token = authHeader.split("Bearer ")[1];
        const loggedInuser = await getLoggedInUser(token);

        let query = await db.checkQueryString(req.query)
        query.ownerId = loggedInuser.payload._id;
        req.populate = [{ path: 'media', match: { deleted: false } }, { path: 'ownerId' }, { path: "buildingId" }, { path: "inspection" }]
        return response.successResponse(res, 200, await db.getItems(req, Project, query), MESSAGE.PROJECT_VIEW_DATA);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

/**
 * Get one Project from database by id
 * @param {string} id - project id
 */
const getProjectDetails = async (req, res) => {
    try {
        const authHeader = req.headers.authorization;
        let token = authHeader.split("Bearer ")[1];
        const loggedInuser = await getLoggedInUser(token);
        const project = await db.getItemByParams(Project, { _id: req.query.id, ownerId: loggedInuser.payload._id },
            [{ path: 'media', match: { deleted: false } }, { path: 'ownerId' }, { path: "buildingId" }, { path: "inspection" }, { path: "existingRoof_type" },
            { path: "material_type" }, { path: "wind_uplift" }, { path: "r_value" }, { path: "newRoof_type" }])
        return response.successResponse(res, 200, project, MESSAGE.PROJECT_VIEW_DATA);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* Get owner Profile details from database by id
* @param {string} id - user id
*/
// const getProfileDetails = async (req, res) => {
//     const authHeader = req.headers.authorization;
//     let token = authHeader.split("Bearer ")[1];
//     const loggedInuser = await getLoggedInUser(token);
//     const owner_id = loggedInuser.payload._id;
//     try {
//         // const owner = await User.findOne({ _id: owner_id }).exec();
//         const owner = await db.getItemByParams(User, {_id: owner_id});
//         return response.successResponse(res, 200, owner);
//     } catch (e) {
//         return response.somethingErrorMsgResponse(res, 500, e);
//     }
// }

// const changePassword = async (req, res) => {
//     // Our logic starts here
//     try {
//         // Get user input
//         const { currentPwd, newPwd } = req.body;

//         // Validate user input
//         if (!currentPwd) {
//             return response.badRequest(res, 400, "Please provide current Password.");
//         } 
//         if (!newPwd) {
//             return response.badRequest(res, 400, "Please provide new Password.");
//         } 

//             const authHeader = req.headers.authorization;
//             let token = authHeader.split("Bearer ")[1];
//             const loggedInuser = await getLoggedInUser(token);

//             // Get current Logged In user detail
//             const user = await User.findOne({ _id: loggedInuser.payload._id });
//             if (user && (await bcrypt.compare(currentPwd, user.password))) {
//                 //Encrypt user password
//                 encryptedPassword = await bcrypt.hashSync(newPwd, 16);
//                 // Find user and update password
//                 let results = await db.updateItem(user._id, User, {password: encryptedPassword, password_change_required:false})

//                 if (results) {
//                     let subject = "Change Password Confirmation";
//                     let text = `Hii ${results.first_name} <br> Your Password has been changed successfully. You can now login with your new Password.`;
//                     mail.sendMail(results.email, subject, text);
//                     return response.successResponse(res, 200, results, MESSAGE.CHANGE_PWD_SUCCESS);
//                   } else {
//                     return response.badRequest(res, 400, MESSAGE.PASSWORD_UPDATE_FAILURE);
//                   }

//             } else {
//                 return response.badRequest(res, 400, MESSAGE.CURRENT_PWD_NOT_MATCHED);
//             }

//     } catch (e) {
//         console.log(e)
//         return response.errorMessageResponse(res, 500, e);
//     }

// }


module.exports = {
    myProjects,
    getProjectDetails
}
