const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { Notifications } = require("../../models");
const db = require("../../services/db");


// sendNotificationTousers
const sendNotificationTousers = async (req, res) => {
    console.log("req.body", req.body)
    // Validate request
    if (!req.body.description) {
        return response.errorMessageResponse(res, 500, MESSAGE.NOTIFICATION_CONTENT_REQUIRED);
    }
    if (!req.body.title) {
        return response.errorMessageResponse(res, 500, MESSAGE.NOTIFICATION_TITLE_REQUIRED);
    }
    if (!req.body.to_user_ids || (req.body.to_user_ids).length == 0) {
        return response.errorMessageResponse(res, 500, MESSAGE.NOTIFICATION_RECEIVER_REQUIRED);
    }

    const payload = {
        title: req.body.title,
        to_user_ids: [...new Set(req.body.to_user_ids)],
        description: req.body.description,
        notify_type: 'GENERAL'
    }
    
    const notification = new Notifications(payload);

    notification.save()
    .then(data => {
        return response.successResponse(res, 200, data, MESSAGE.NOTIFICATION_SENT_SUCCESS);
    }).catch(err => {
        return response.badRequest(res, 400, err.message || MESSAGE.NOTIFICATION_SENT_FAILED);
    });
};

module.exports = {
    sendNotificationTousers
}
