const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { NotificationsSettings} = require("../../models");
const db = require("../../services/db");

// Retrieve and return all pages from the database.
const findAll = async (req, res) => {
    try {
        const page = await NotificationsSettings.find({}).sort([["updatedAt",-1]]);
        return response.successResponse(res, 200, await db.getItems(req, NotificationsSettings), MESSAGE.NOTIFICATION_SETTINGS_GET_DATA);

    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
  };

// Update Notification settings 
const update = async (req, res) => {
    // Validate request
    if (!req.body.notification_content) {
        return response.errorMessageResponse(res, 500, MESSAGE.NOTIFICATION_SETTINGS_CONTENT_REQUIRED);
      }
    if (!req.body.title) {
    return response.errorMessageResponse(res, 500, MESSAGE.NOTIFICATION_SETTINGS_TITLE_REQUIRED);
    }

    const payload = {
        title: req.body.title,
        enabled: req.body.enabled,
        notification_content: req.body.notification_content,
    }
    let results = await db.updateItem(req.body._id, NotificationsSettings, payload)

    if (results) {
        return response.successResponse(res, 200, results, MESSAGE.NOTIFICATION_SETTINGS_UPDATE_SUCCESS);
        } 
    else {
        return response.badRequest(res, 400, MESSAGE.NOTIFICATION_SETTINGSE_UPDATE_FAILURE);
        }
};

module.exports = {
   findAll,
   update
}
