const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { NewRoofType } = require("../../models");
const db = require("../../services/db");

/**
 * Creates a new Roof Type in database
 * @param {Object} req - request object
 */
const add = async (req, res) => {
    const {
        roof_type_name,
        price,
        description
    } = req.body;
    try {
        const newRoofType = new NewRoofType({
            roof_type_name,
            price,
            description
        });
        const SaveNewRoofType = await newRoofType.save();
        return response.successResponse(res, 200, SaveNewRoofType, MESSAGE.NEW_ROOF_TYPE_ADD_SUCCESS);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* Update a New roof Type in database by id
* @param {string} id - item id
* @param {Object} req - request object
*/
const update = async (req, res) => {
    const {
        roof_type_name,
        price,
        description
    } = req.body;
    try {
        var result = await NewRoofType.findByIdAndUpdate(
            (_id = req.body._id),
            {
                roof_type_name,
                price,
                description
            },
            { new: true }
        );
        if (result) {
            return response.successResponse(res, 200, result, MESSAGE.NEW_ROOF_TYPE_UPDATE_SUCCESS);

        } else {
          
            return response.badRequest(res, 400, MESSAGE.NEW_ROOF_TYPE_NOT_FOUND);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* Get All New Roof type from database by role
* @param {string} req - object
*/
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        return response.successResponse(res, 200, await db.getItems(req, NewRoofType, query), MESSAGE.NEW_ROOF_TYPE_VIEW_DATA);
    } catch (error) {
        console.log(error);
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

/**
* Get one New Roof Type from database by id
* @param {string} id - user id
*/
const viewOne = async (req, res) => {
    const new_roof_id = req.query.id;
    try {
        const newRoofType = await NewRoofType.findOne({ _id: new_roof_id }).exec();
        return response.successResponse(res, 200, newRoofType);
    }
    catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* Delete one New Roof type from database by id
* @param {string} id - user id
*/
const deleteNewRoofType = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, NewRoofType)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.NEW_ROOF_TYPE_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* toggle change for New Roof type from database by id
* @param {string} id - New Roof type id
*/
const updateStatus = (req, res) => {
    const new_roof_id = req.body.id;
    NewRoofType.findOne({ _id: new_roof_id }, (err, new_roof) => {
        new_roof.status = !new_roof.status;
        new_roof.save((err, updatedNewRoofType) => {
            if (!err) {
                return response.successResponse(res, 200, { status: new_roof.status }, MESSAGE.NEW_ROOF_TYPE_STATUS_UPDATED);
            } else {
                return response.somethingErrorMsgResponse(res, 500, error);
            }
        });
    });
};

module.exports = {
    add,
    update,
    viewAll,
    viewOne,
    deleteNewRoofType,
    updateStatus
}