const model = require('../../models/Module')
const { matchedData } = require('express-validator')
const utils = require('../../services/utils')
const db = require('../../services/db')
const mongoose = require('mongoose')
const e = require('express')
/********************
 * Public functions *
 ********************/

/**
 * Create item function called by route
 * @param {Object} req - request object
 * @param {Object} res - response object
 */

exports.createItem = async (req, res) => {
    try {
        let data = { ...req.body };
        if (!await db.existItemByParams(model, { "name": data.name }))
            res.status(201).json(await db.insertItem(model, data))
    } catch (error) {
        console.log(error);
        utils.handleError(res, error)
    }
}

/**
 * Get items function called by route
 * @param {Object} req - request object
 * @param {Object} res - response object
 */
exports.getItems = async (req, res) => {
    try {
        const query = await db.checkQueryString(req.query)
        res.status(200).json(await db.getItems(req, model, query))
    } catch (error) {
        utils.handleError(res, error)
    }
}

/**
 * Get item function called by route
 * @param {Object} req - request object
 * @param {Object} res - response object
 */
exports.getItem = async (req, res) => {
    try {
        req = matchedData(req)
        let result = { category: await db.getItemsByParams(model, { name: 1 }, { link: { $exists: false } }) }
        if (req?.id) {
            const id = await utils.isIDGood(req?.id)
            result = { ...result, detail: await db.getItem(id, model) }
        }
        res.status(200).json(result)
    } catch (error) {
        utils.handleError(res, error)
    }
}

/**
 * Update item function called by route
 * @param {Object} req - request object
 * @param {Object} res - response object
 */
// exports.updateItem = async (req, res) => {
//     try {
//         req = await utils.unsetFields(matchedData(req))
//         const id = await utils.isIDGood(req.id)
//         if (req?.name)
//             await db.existItemByParams(model, { "name": req.name, _id: { $ne: id } })
//         if (req?.id) {
//             if (req?.status && !JSON.parse(req?.status))
//                 //   await db.isAssociated(assignPermissionModel, { "order": { $in: [`${req?.id}`] } })
//                 await db.updateItem(id, model, req)
//             let options = { path: 'roles', select: "role_id", populate: { path: "role_id", select: "name color" } }
//             let result = await db.getItemWithPopulate(id, model, options)
//             return response.successResponse(res, 200,result, MESSAGE.LOGIN_SUCCESS)
//         }

//     } catch (error) {
//         return response.somethingErrorMsgResponse(res, 200, "not found!");
//     }
// }
exports.updateItem = async (req, res) => {
    try {
        const id = req.params.id
        let results = await db.updateItem(id, model, req.body)
        let options = { path: 'roles', select: "role_id", populate: { path: "role_id", select: "name color" } }
        results = await db.getItemWithPopulate(id, model, options)
        res.status(200).json(results)
    } catch (error) {
        utils.handleError(res, error)
    }
}


/**
 * Update multiple item function called by route
 * @param {Object} req - request object
 * @param {Object} res - response object
 */
exports.updateMultiItem = async (req, res) => {
    try {
        // req = matchedData(req)
        // await db.isAssociated(assignPermissionModel, { "order": { $in: req.ids } })
        res.status(200).json(await db.updateMultiItem(req.ids, model, req))
    } catch (error) {
        utils.handleError(res, error)
    }
}
/**
 * Soft delete multiple/single item function called by route
 * @param {Object} req - request object
 * @param {Object} res - response object
 */
exports.softDeleteItems = async (req, res) => {
    try {
        req = matchedData(req)
        let ids = Array.isArray(req.ids) ? req.ids : [req.ids]
        // await db.isAssociated(assignPermissionModel, { "order": { $in: ids } })
        res.status(200).json(await db.softDeleteItems(ids, model))
    } catch (error) {
        utils.handleError(res, error)
    }
}



