const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { Project, Media } = require("../../models");
const moment = require("moment");
const db = require("../../services/db")
const { removeEmptyKeys } = require("../../services/utils");

/**
 * Creates a new Project in database
 * @param {Object} req - request object
 */
const addMedia = async (req, res) => {
    try {
        let params = removeEmptyKeys(req.body)
        let results = req.body.id;
        let media = [];
        // FOR roofing_images
        if (req?.files?.images) {
            req.files.images.forEach((element) => {
                media.push({ path: "public/uploads/" + element.filename, filename: element.filename, ref_id: results, type: "images" });
            });
        }
        if (req?.files?.roof_drawings) {
            req.files.roof_drawings.forEach((element) => {
                media.push({ path: "public/uploads/" + element.filename, filename: element.filename, ref_id: results, type: "roof_drawings" });
            });
        }
        if (req?.files?.standard_contract) {
            req.files.standard_contract.forEach((element) => {
                media.push({ path: "public/uploads/" + element.filename, filename: element.filename, ref_id: results, type: "standard_contract" });
            });
        }
        if (req?.files?.insurance) {
            req.files.insurance.forEach((element) => {
                media.push({ path: "public/uploads/" + element.filename, filename: element.filename, ref_id: results, type: "insurance" });
            });
        }
        if (req?.files?.detail_drawings) {
            req.files.detail_drawings.forEach((element) => {
                media.push({ path: "public/uploads/" + element.filename, filename: element.filename, ref_id: results, type: "detail_drawings" });
            });
        }
        if (req?.files?.specifications) {
            req.files.specifications.forEach((element) => {
                media.push({ path: "public/uploads/" + element.filename, filename: element.filename, ref_id: results, type: "specifications" });
            });
        }
        if (req?.files?.videos) {
            req.files.videos.forEach((element) => {
                media.push({ path: "public/uploads/" + element.filename, filename: element.filename, ref_id: results, type: "videos" });
            });
        }
        // store all images,documents and videos
        await Media.insertMany(media);
        return response.successResponse(res, 200, MESSAGE.MEDIA_ADD_SUCCESS)
    } catch (e) {
        return response.errorMessageResponse(res, 500, e);
    }
}

/**
* Soft Delete one documents from database by id
* @param {string} id - project Id
*/
  const deleteDocument = async (req, res) => {
    try {
      const result = await db.softDeleteItems(req.params.id, Media)
      if (result) {
        return response.successResponse(res, 200, {}, MESSAGE.MEDIA_DELETE_SUCCESS);
      } else {
        return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
      }
    } catch (e) {
      return response.somethingErrorMsgResponse(res, 500, e);
    }
  }
  
module.exports = {
    addMedia,
    deleteDocument,
}