const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { MaterialType } = require("../../models");
const db = require("../../services/db");

/**
 * Creates a new Material Type in database
 * @param {Object} req - request object
 */
const add = async (req, res) => {
    const {
        material_name,
        material_type,
        // price,
        description
    } = req.body;
    try {
        const materialType = new MaterialType({
            material_name,
            material_type,
            // price,
            description
        });
        const SaveMaterialType = await materialType.save();
        return response.successResponse(res, 200, SaveMaterialType, MESSAGE.MATERIAL_ADD_SUCCESS);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* Update a Material in database by id
* @param {string} id - item id
* @param {Object} req - request object
*/
const update = async (req, res) => {
    const {
        material_name,
        material_type,
        // price,
        description
    } = req.body;
    try {
        var result = await MaterialType.findByIdAndUpdate(
            (_id = req.body._id),
            {
                material_name,
                material_type,
                // price,
                description
            }
        );
        if (result) {
            return response.successResponse(res, 200, result, MESSAGE.MATERIAL_UPDATE_SUCCESS);
        } else {
            return response.badRequest(res, 400, MESSAGE.MATERIAL_NOT_FOUND);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* Get All Material from database by role
* @param {string} req - object
*/
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        return response.successResponse(res, 200, await db.getItems(req, MaterialType, query), MESSAGE.MATERIAL_VIEW_DATA);
    } catch (error) {
        console.log(error);
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

/**
* Get one Material from database by id
* @param {string} id - user id
*/
const viewOne = async (req, res) => {
    const material_id = req.query.id;
    try {
        const material = await MaterialType.findOne({ _id: material_id }).exec();
        return response.successResponse(res, 200, material);
    }
    catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* Delete one Contractor from database by id
* @param {string} id - user id
*/
const deleteMaterialType = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, MaterialType)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.MATERIAL_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* toggle change for materialType from database by id
* @param {string} id - material id
*/
const updateStatus = (req, res) => {
    const material_id = req.body.id;
    MaterialType.findOne({ _id: material_id }, (err, material) => {
        material.status = !material.status;
        material.save((err, updatedMaterial) => {
            if (!err) {
                return response.successResponse(res, 200, { status: material.status }, MESSAGE.MATERIAL_STATUS_UPDATED);
            } else {
                return response.somethingErrorMsgResponse(res, 500, error);
            }
        });
    });
};

module.exports = {
    add,
    update,
    viewAll,
    viewOne,
    deleteMaterialType,
    updateStatus
}