const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { masterLineItemModel } = require("../../models");
const db = require("../../services/db");

/**
* Get All estimate from database
* @param {string} req - object
*/
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        if (req?.query?.ignoreRecords) {
            query._id = { $nin: req?.query?.ignoreRecords }
        }
        return response.successResponse(res, 200, await db.getItems(req, masterLineItemModel, query), MESSAGE.MASTER_LINE_ITEM_LIST);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

const add = async (req, res) => {
    const { item } = req.body;
    try {
        const lineItemPayload = new masterLineItemModel({
            item
        });
        const save = await lineItemPayload.save();
        return response.successResponse(res, 200, save, MESSAGE.MASTER_LINE_ITEM_ADD);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const updateLineItem = async (req, res) => {
    // Validate request
    const lineItemAlreadyExist = await masterLineItemModel.find({  _id: { $ne: req.body._id }, item: req.body.item });
    // check if lineitem already exist with same name.
    if (lineItemAlreadyExist.length > 0) {
        return response.errorMessageResponse(res, 500, MESSAGE.MASTER_LINE_ITEM_DUPLICATE)
      }
    const payload = {
        item: req.body.item
    }
    let results = await db.updateItem(req.body._id, masterLineItemModel, payload)

    if (results) {
        return response.successResponse(res, 200, results, MESSAGE.MASTER_LINE_ITEM_UPDATE_SUCCESS);
    } else {
        return response.badRequest(res, 400, MESSAGE.MASTER_LINE_ITEM_UPDATE_FAILED);
    }
};

module.exports = {
    viewAll,
    add,
    updateLineItem
}