const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { masterProjectDescriptionModel } = require("../../models");
const db = require("../../services/db");

/**
* Creates a new Master project Description in database
* @param {Object} req - request object
*/
const add = async (req, res) => {
    const { title, description } = req.body;
    if (!req.body.title) {
        return response.badRequest(res, 400, MESSAGE.MASTER_PD_INPUT_RERQUIRED);
    } 
    if (!req.body.description) {
        return response.badRequest(res, 400, MESSAGE.MASTER_PD_INPUT_RERQUIRED);
    }
    try {
        const masterPD = new masterProjectDescriptionModel({
            title,
            description
        });
        const save = await masterPD.save();
        return response.successResponse(res, 200, save, MESSAGE.MASTER_PD_ADD);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const updateMasterProjectDescritpion = async (req, res) => {
    // Validate request
    if (!req.body.title) {
        return response.badRequest(res, 400, MESSAGE.MASTER_PD_INPUT_RERQUIRED);
    } 
    if (!req.body.description) {
        return response.badRequest(res, 400, MESSAGE.MASTER_PD_INPUT_RERQUIRED);
    }
   
    const payload = {
        title: req.body.title,
        description: req.body.description
    }
    let results = await db.updateItem(req.body._id, masterProjectDescriptionModel, payload)

    if (results) {
        return response.successResponse(res, 200, results, MESSAGE.MASTER_PD_UPDATE_SUCCESS);
    } else {
        return response.badRequest(res, 400, MESSAGE.MASTER_PD_UPDATE_FAILED);
    }
};

/**
* Get All Master project Description List from database
* @param {string} req - object
*/
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        if (req?.query?.ignoreRecords) {
            query._id = { $nin: req?.query?.ignoreRecords }
        }
        return response.successResponse(res, 200, await db.getItems(req, masterProjectDescriptionModel, query), MESSAGE.MASTER_PD_LIST);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

/**
 * Detete one Master Project Description from database by id
 * @param {string} id - req
 */
const deleteMasterDescription = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, masterProjectDescriptionModel)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.MASTER_PD_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const fullData = async (req, res) => {
    try {
        const masterDescriptionData = await masterProjectDescriptionModel.find({deleted:false});
        return response.successResponse(res, 200, masterDescriptionData, MESSAGE.MASTER_PD_LIST);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
module.exports = {
    viewAll,
    fullData,
    add,
    deleteMasterDescription,
    updateMasterProjectDescritpion
}