const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { Project, User , Building } = require("../../models");
const db = require("../../services/db")
const { getLoggedInUser } = require("../../utils/jwtToken");

/**
 * Get All Project from database 
 * @param {string} req - project 
 */
const myProjects = async (req, res) => {
    try {
        const authHeader = req.headers.authorization;
        let token = authHeader.split("Bearer ")[1];
        const loggedInuser = await getLoggedInUser(token);
        const manufacturerDetails = await User.findOne({ deleted:false , _id: loggedInuser.payload._id});
        if(manufacturerDetails){
            const buildingsInMyLocation = await Building.find({ deleted:false , state: manufacturerDetails.state });
            const buildingIds = [];
            await buildingsInMyLocation.forEach(building => {
                buildingIds.push(building._id);
            });
            // const myProjects = await Project.find({ deleted:false , buildingId: { $in: buildingIds } });
            let query = await db.checkQueryString(req.query);
            query.buildingId = {$in:buildingIds}
            req.populate = [{ path: 'media', match: { deleted: false } }, { path: 'ownerId' }, { path: "buildingId" }, { path: "inspection" }]
            return response.successResponse(res, 200, await db.getItems(req, Project, query), MESSAGE.PROJECT_VIEW_DATA);

        }else{
            return response.somethingErrorMsgResponse(res, 500, "User details not found");
        }
    } catch (error) {
        console.log(error)
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

module.exports = {
    myProjects
}
