const { Bid } = require("../../models");
const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { getinvoiceHtmlTemplate } = require("../../utils/Invoice-genrator")
const template = require("./template");
const mail = require("../../utils/notify");

/**
   * @description Function For List of all MANUFACTURER with respective Role.
   * @param {object} req 
   * @param {object} res 
   */

const createInvoice = async (req, res) => {

    const { bid_id } = req.body;
    const html_to_pdf = require('html-pdf-node');
    const options = { format: 'A4', path: `./pdf/${bid_id}.pdf` };
    let file = {
        content: template
    };
    html_to_pdf.generatePdf(file, options)
        .then(async (re) => {
            const result = await Bid.findByIdAndUpdate((_id = bid_id), { is_invoice_generated: true }, { returnOriginal: false });
            res.status(200).send({
                message: "Invocie created successfully",
                isSuccess: true,
                filename: `${bid_id}.pdf`,
                bid: result
            })
        }).catch((err) => {
            res.status(200).send({
                isSuccess: false,
                error: err
            })
        });
}
const downloadInvoice = async (req, res) => {
    try {
        const { bid_id } = req.query;
        res.download(`./pdf/${bid_id}.pdf`);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

const mailInvoice = async (req, res) => {
    try {
        const { bid_id, email } = req.body;
        const invoiceContent = await fs.readFile(`./pdf/${bid_id}.pdf`);
        let subject = "Invocie";
        let text = `hi ${email} <br> find attached invoice.`;
        mail.sendMail(email, subject, text, `${bid_id}.pdf`, invoiceContent);
        return response.successResponse(res, 200, result, "Mail sent!!");
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
const getListOfProjectWithInvoices = async (req, res) => {
    try {
        const result = await Bid.aggregate().match({ is_invoice_generated: true }).lookup({ from: 'projects', localField: 'project_Id', foreignField: '_id', as: 'project' }).group({ _id: "$project_Id", bids: { $push: "$$ROOT" } }).exec();
        return response.successResponse(res, 200, result, "fetched result successfully");
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}
module.exports = {
    createInvoice,
    downloadInvoice,
    mailInvoice,
    getListOfProjectWithInvoices
}