const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { Inspection } = require("../../models");
const { emailStatus } = require("../../utils/getUser");
// const { Inspection } = require("../../constants/roles");
const bcrypt = require("bcryptjs");
const { _value } = require("../../utils/getRandom");
const db = require("../../services/db");
const mail = require("../../../MEAN-Roofing/utils/notify");
const mediaUtils = require("../../utils/unlinkMedia");

/**
 * Creates a new Inspection in database
 * @param {Object} req - request object
 */
const add = async (req, res) => {
    try {
        const { inspector_name, projectId, date, remark, country, state, city } = req.body;
        let documents = [];

        if (req.files) {
            const mediaRootPath = "public/uploads/inspections/" + req.body.projectId + '/';
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const MediaFiles = req.files[key];
                    await MediaFiles.forEach(async mediaFile => {
                        documents.push({
                            path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                            filename: mediaFile.filename,
                            type: mediaFile.fieldname
                        });
                    })

                } else {
                    console.log("Else condition block")
                }
            })
        }
        const inspection = new Inspection({
            inspector_name,
            projectId,
            date,
            documents,
            remark,
            country,
            state,
            city
        });
        inspection.save()
        .then(data => {
            return response.successResponse(res, 200, data, MESSAGE.INSPECTION_ADD_SUCCESS)

        }).catch(err => {
            console.log("inspecting save error", err)
            // delete all uploaded inspection media files
            documents.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return response.badRequest(res, 400, MESSAGE.INSPECTION_NOT_FOUND);
        });
    } catch (e) {
        console.log("final Cath error", e)
        // delete all uploaded inspection media files
        if (req.files) {
            const mediaRootPath = "public/uploads/inspections/" + req.body.projectId + '/';
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const inspectionMediaFiles = req.files[key];
                    await inspectionMediaFiles.forEach(async mediaFile => {
                        // call util method to remove file from location
                        mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                    })
                }
            })
        }
        return response.errorMessageResponse(res, 500, e);
    }
}

// Retrieve and return all inspections from the database.
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        req.populate = { path: 'projectId', populate: [{ path: 'media' }], match: { deleted: false } }
        return response.successResponse(res, 200, await db.getItems(req, Inspection, query), MESSAGE.INSPECTION_GET_DATA);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
};

/**
* Get one Contractor from database by id
* @param {string} id- user id
*/
const viewOne = async (req, res) => {
    try {
        const inspection = await db.getItemWithPopulate(req.query.id, Inspection,
            { path: 'projectId', populate: [{ path: 'media' }], match: { deleted: false } })
        return response.successResponse(res, 200, inspection);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

// Update Inspection details
const update = async (req, res) => {
    let documents = [];

    if (req.files) {
        const mediaRootPath = "public/uploads/inspections/" + req.body.projectId + '/';
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const MediaFiles = req.files[key];
                await MediaFiles.forEach(async mediaFile => {
                    documents.push({
                        path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                        filename: mediaFile.filename,
                        type: mediaFile.fieldname
                    });
                })

            } else {
                console.log("Else condition block")
            }
        })
    }

    const payload = {
        inspector_name: req.body.inspector_name || '',
        projectId: req.body.projectId,
        date: req.body.date,
        documents: req.body.existing_documents && req.body.existing_documents.length > 0 ? [...JSON.parse(req.body.existing_documents), ...documents] : documents,
        remark: req.body.remark || '',
        country: req.body.country,
        state: req.body.state,
        city: req.body.city
    }
    let results = await db.updateItem(req.body._id, Inspection, payload)

    if (results) {
        // Remove all the removed media from directory and Media Collection
        if (req.body.removed_items) {
            const filesTobeRemoved = JSON.parse(req.body.removed_items);
            await filesTobeRemoved.forEach(element => {
                mediaUtils.unlink(element.path);
            });
        }
        return response.successResponse(res, 200, results, MESSAGE.INSPECTION_UPDATE_SUCCESS);
    } else {
        documents.forEach(element => {
            mediaUtils.unlink(element.path);
        });
        return response.badRequest(res, 400, MESSAGE.INSPECTION_UPDATE_FAILURE);
    }
};

const deleteInspection = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, Inspection)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.INSPECTION_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

module.exports = {
    add,
    viewAll,
    update,
    viewOne,
    deleteInspection
};
