const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { graphReports  ,Project, User, ApplicationSetting, projectBidSubmission} = require("../../models");
const db = require("../../services/db");
const { getLoggedInUser } = require("../../utils/jwtToken");

// Create and Save a graph report template
const create = async (req, res) => {
    // Validate request
    if(!req.body.report_name ) {
        return response.errorMessageResponse(res, 500, MESSAGE.GRAPH_REPORT_NAME_REQUIRED);
      }
    if(!req.body.type) {
    return response.badRequest(res, 400, MESSAGE.GRAPH_REPORT_TYPE_REQUIRED);
    }
    if(!req.body.yaxis) {
        return response.badRequest(res, 400, MESSAGE.GRAPH_REPORT_YAXIS_REQUIRED);
    }
    if(!req.body.xaxis) {
        return response.badRequest(res, 400, MESSAGE.GRAPH_REPORT_XAXIS_REQUIRED);
    }
    const authHeader = req.headers.authorization;
    let token = authHeader.split("Bearer ")[1];
    const loggedInuser = await getLoggedInUser(token);
    const userId = loggedInuser.payload._id;
    // Create a graph report template
    const payload = new graphReports({
        report_name: req.body.report_name,
        description: req.body.description,
        type: req.body.type,
        yaxis: req.body.yaxis, //total_cost , total_size , avg_cost , avg_size
        xaxis: req.body.xaxis, //manufacturer , contractor , won_bids , no_of_bids
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        quaters: req.body.quaters, //Q1,Q2,Q3,Q4
        date_range: req.body.date_range, //{start:'',end:''}
        selectedMenuItems: req.body.selectedMenuItems ? req.body.selectedMenuItems : [] ,
        createdBy: userId,
    });

    // Save record in the database
    payload.save()
    .then(data => {
        return response.successResponse(res, 200, data, MESSAGE.GRAPH_REPORTS_ADD_SUCESS);
    }).catch(err => {
        return response.errorMessageResponse(res, 500, err);
    });
};

const getGraphreportsTemplateList = async(req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        return response.successResponse(res, 200, await db.getItems(req, graphReports, query), MESSAGE.GRAPH_REPORTS_LIST);
    } catch (e) {
        console.log(e)
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};


const updateGraphTemplate = async (req, res) => {
   // Validate request
    if(!req.body.report_name ) {
        return response.errorMessageResponse(res, 500, MESSAGE.GRAPH_REPORT_NAME_REQUIRED);
    }
    if(!req.body.type) {
    return response.badRequest(res, 400,MESSAGE.GRAPH_REPORT_TYPE_REQUIRED);
    }
    if(!req.body.yaxis) {
        return response.badRequest(res, 400,MESSAGE.GRAPH_REPORT_YAXIS_REQUIRED);
    }
    if(!req.body.xaxis) {
        return response.badRequest(res, 400, MESSAGE.GRAPH_REPORT_XAXIS_REQUIRED);
    }
    const authHeader = req.headers.authorization;
    let token = authHeader.split("Bearer ")[1];
    const loggedInuser = await getLoggedInUser(token);
    const userId = loggedInuser.payload._id;
    const payload = {
        report_name: req.body.report_name,
        description: req.body.description,
        type: req.body.type,
        yaxis: req.body.yaxis, //total_cost , total_size , avg_cost , avg_size
        xaxis: req.body.xaxis, //manufacturer , contractor , won_bids , no_of_bids
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        quaters: req.body.quaters, //Q1,Q2,Q3,Q4
        date_range: req.body.date_range, //{start:'',end:''}
        selectedMenuItems: req.body.selectedMenuItems ? req.body.selectedMenuItems : [] ,
        createdBy: userId,
    }
    let results = await db.updateItem(req.body._id, graphReports, payload)

    if (results) {
        return response.successResponse(res, 200, results, MESSAGE.GRAPH_REPORTS_UPDATE_SUCESS);
    } else {
        return response.badRequest(res, 400, MESSAGE.SOMETHING_WENT_WRONG);
    }
};

const deleteReport= async (req, res) => {
    try {
        const result = await db.deleteItem(req.params.id, graphReports)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.GRAPH_REPORT_DELETE_SUCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};
const getGraphData = async (req , res)=> {
    console.log("req.body data for graph criteria", req.body)
    // const templatetypesCount = await Project.aggregate(
    //     [
    //         {
    //            $group: { _id: "$buildingId"},
    //        }
    //     ]);

    // const data = await User.aggregate([
    //     {
    //         $lookup: {
    //           from: 'Project',
    //           localField: '_id',
    //           foreignField: 'manufacturers',
    //           as: 'manufacturers',
    //         },
    //       },
    //       {
    //         $group: {
    //           _id: _id, // calculate for all
    //         },
    //       }
    // ])
    // const data = await Project.find({}).select("-bidder -documents -longitude -lattitude -transaction_ids -participating_bidders -allowedBid -description -notes -bids_submission -bid_end_date -bidder_fee -loc -BidActivity -bid_start_date -associatedEstimatorAssistance  -createdAt -updatedAt -projectDescription");
    const menusData = await ApplicationSetting.find({_id:{$in:req.body.selectedMenuItems},deleted:false});
    // const customers = await projectBidSubmission.aggregate(
    //     [
    //         { "$match": { "is_bid_winner": true } },
           
    //         {
    //            $group: { _id: "$submitted_by" },
    //        }
    //     ]);
    // const roof = await projectBidSubmission.aggregate(
    //     [
    //         { "$match": { "is_bid_winner": true } },
            
    //         {
    //             $group: { _id: "$submitted_by" },
    //         }
    //     ]);

    let finalGraphData = [];
    for(const element of menusData){
        let menuWiseProjects = {
            menu_id: element._id,
            menu_title : element.menu_title,
            optionWiseProjectsData:[]
        } ;
        for(const items of element.options){
            // const matchedProjects = await Project.find({'selectedMenuItems.menuId' :element._id ,  "selectedMenuItems.selectedOptions":items.value})
            if(req.body.selectedValues.includes(items.value)){
                console.log("selected criteria matched", items)
                const query = {'selectedMenuItems.menuId' :element._id ,  "selectedMenuItems.selectedOptions":items.value};
                if(req.body.country && req.body.country !=''){
                    query['country']= req.body.country ;
                }
                if(req.body.state && req.body.state !=''){
                    query['state']= req.body.state ;
                }
                if(req.body.city && req.body.city !=''){
                    query['city']= req.body.city ;
                }
                if(req.body.approach_type && req.body.approach_type !=''){
                    query['approach_type']= req.body.approach_type ;
                }
                console.log("query", query)

                const matchedProjects = await Project.find(query)

                .populate([{path:'bids_submission', match: {
                    is_bid_winner: true,
                    bid_status:'CLOSED'
                 },
                 select:['total_bid_amount','total_bid_amount_in_words','is_bid_winner','bid_status']
                }])
                .select("-bidder -documents -longitude -lattitude -transaction_ids -participating_bidders -allowedBid -description -notes  -bid_end_date -bidder_fee -loc -BidActivity -bid_start_date -associatedEstimatorAssistance  -createdAt -updatedAt -projectDescription -selectedMenuItems");
                let dataTopush = {
                    title: items.key,
                    value: items.value,
                    projects: matchedProjects
                }
                menuWiseProjects.optionWiseProjectsData.push(dataTopush)
            }else{
                let dataTopush = {
                    title: items.key,
                    value: items.value,
                    projects: []
                }
                menuWiseProjects.optionWiseProjectsData.push(dataTopush)
            }
           
        }
        // console.log("Out side menuwiseData projects", menuWiseProjects);
        finalGraphData.push(menuWiseProjects)

    }

    // await menusData.forEach(async (element, i) => {
    //     let menuWiseProjects = {
    //         menu_id: element._id,
    //         menu_title : element.menu_title,
    //         optionWiseProjectsData:[]
    //     } ;

    //     // element[i]['optionWiseProjectsData'] = [] ;
    //     menusData[i].projectData = [];
    //     console.log("element", element.menu_title)
    //     // console.log("query",{'selectedMenuItems.menuId' :element._id })

    //     for(const items of element.options){
    //         const matchedProjects = await Project.find({'selectedMenuItems.menuId' :element._id ,  "selectedMenuItems.selectedOptions":items.value}).select("-bidder -documents -longitude -lattitude -transaction_ids -participating_bidders -allowedBid -description -notes -bids_submission -bid_end_date -bidder_fee -loc -BidActivity -bid_start_date -associatedEstimatorAssistance  -createdAt -updatedAt -projectDescription");
    //         let dataTopush = {
    //             title: items.key,
    //             projects: matchedProjects
    //         }
    //         // console.log("data TO push", dataTopush)
    //         menuWiseProjects.optionWiseProjectsData.push(dataTopush)
    //         // console.log("menuwiseData projects", menuWiseProjects.optionWiseProjectsData)
    //         // const optData = menuWiseProjects.optionWiseProjectsData;
    //         // optData.push(dataTopush);
    //     }
    //     console.log("Out side menuwiseData projects", menuWiseProjects)

    //     // await element.options.forEach(async (items,j) => {
    //     //     const matchedProjects = await Project.find({'selectedMenuItems.menuId' :element._id ,  "selectedMenuItems.selectedOptions":items.value}).select("-bidder -documents -longitude -lattitude -transaction_ids -participating_bidders -allowedBid -description -notes -bids_submission -bid_end_date -bidder_fee -loc -BidActivity -bid_start_date -associatedEstimatorAssistance  -createdAt -updatedAt -projectDescription");
    //     //     let dataTopush = {
    //     //         title: items.key,
    //     //         projects: matchedProjects
    //     //     }
    //     //     console.log("data TO push", dataTopush)
    //     //     // const optData = menuWiseProjects.optionWiseProjectsData;
    //     //     // optData.push(dataTopush);
    //     // })
    //     // console.log("element options", element.options);
    //     finalGraphData.push(menuWiseProjects)
    // });
    res.send(finalGraphData);
};

module.exports = {
   create,
   getGraphreportsTemplateList,
   updateGraphTemplate,
   deleteReport,
   getGraphData
}
