const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { Faq } = require("../../models");
const db = require("../../services/db");

/**
* Creates a new FAQ in database
* @param {Object} req - request object
*/
const add = async (req, res) => {

    const { faq_question, faq_answer, status } = req.body;
    // Validate user input
    if (!faq_question) {
        return response.badRequest(res, 400, MESSAGE.FAQ_FAQ_QUESTION_EMPTY_ERROR);
    }
    if (!faq_answer) {
        return response.badRequest(res, 400, MESSAGE.FAQ_FAQ_ANSWER_EMPTY_ERROR);
    }
    const faq = new Faq({
        faq_question,
        faq_answer,
        status
    });
    try {
        const saveFaq = await faq.save();
        return response.successResponse(
            res,
            200,
            saveFaq,
            MESSAGE.FAQ_ADD_SUCCESS
        );
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const update = async (req, res) => {
    const { faq_question, faq_answer, status } = req.body;
    // Validate user input
    if (!faq_question) {
        return response.badRequest(res, 400, MESSAGE.FAQ_FAQ_QUESTION_EMPTY_ERROR);
    }
    if (!faq_answer) {
        return response.badRequest(res, 400, MESSAGE.FAQ_FAQ_ANSWER_EMPTY_ERROR);
    }
    try {
        var result = await Faq.findByIdAndUpdate(
            (_id = req.body._id),
            {
                faq_question,
                faq_answer,
                status,
                updatedBy: req.id,
            },
            { new: true }
        );

        if (result) {
            return response.successResponse(
                res,
                200,
                result,
                MESSAGE.FAQ_UPDATE_SUCCESS
            );
        } else {
            return response.badRequest(res, 400, MESSAGE.FAQ_NOT_FOUND);
        }
    } catch (e) {
        console.log(e)
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

/**
* Get All FAQ from database by role
* @param {string} req - object
*/
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        return response.successResponse(res, 200, await db.getItems(req, Faq, query), MESSAGE.FAQ_VIEW_DATA);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

/**
 * Gets one Building from database by id
 * @param {string} id - req
 */
const viewOne = async (req, res) => {
    try {
        const faq = await db.getItemByParams(Faq, { _id: req.query._id })
        return response.successResponse(res, 200, faq);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const deleteFaq = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, Faq)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.FAQ_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};


module.exports = {
    viewAll,
    add,
    update,
    deleteFaq,
    viewOne
}