const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { Estimator } = require("../../models");
const db = require("../../services/db");

/**
* Creates a new Estimate in database
* @param {Object} req - request object
*/
const add = async (req, res) => {
    const { title, description } = req.body;
    try {
        const estimator = new Estimator({
            title,
            description
        });
        const save = await estimator.save();
        return response.successResponse(res, 200, save, MESSAGE.ESTIMATE_ADD);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

/**
* Update multi estimate from database
* @param {string} req - object
*/
const update = async (req, res) => {
    try {
        let updatedRecords = []
        for (var i = 0; i < req.body.description.length; i++) {
            req.body.description[i].projectId = req.body.projectId
            // if (req.body.description[i]?.isNew) {
            //     delete req.body.description[i]?._id
            //     updatedRecords.push(await db.createItem(
            //         req.body.description[i],
            //         Estimator,
            //     ))
            // }
            // else {
            let _id = req.body.description[i]?._id
            updatedRecords.push(await db.updateItem(
                _id,
                Estimator,
                req.body.description[i]
            ))
            // }
        }
        return response.successResponse(res, 200, updatedRecords, MESSAGE.ESTIMATE_UPDATE_SUCCESS);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

/**
* Get All estimate from database
* @param {string} req - object
*/
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        if (req?.query?.ignoreRecords) {
            query._id = { $nin: req?.query?.ignoreRecords }
        }
        return response.successResponse(res, 200, await db.getItems(req, Estimator, query), MESSAGE.ESTIMATE_LIST);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

/**
 * Get one estimate from database by id
 * @param {string} id - req
 */
const viewOne = async (req, res) => {
    try {
        const estimator = await db.getItemByParams(Estimator, { _id: req.query._id })
        return response.successResponse(res, 200, estimator);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

/**
 * Detete one estimate from database by id
 * @param {string} id - req
 */
const deleteEstimator = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, Estimator)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.ESTIMATE_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

module.exports = {
    viewAll,
    add,
    update,
    deleteEstimator,
    viewOne
}