const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { Bid, Project, User , Building , projectBidSubmission} = require("../../models");
const db = require("../../services/db");
const { getLoggedInUser } = require("../../utils/jwtToken");


// Get all Dashboard Data for ADMIN dashboard
const getDashboardData = async (req, res) => {
    try {
        
        const totalActiveBids = await projectBidSubmission.find({ bid_status:'OPEN' }).count();
        const winningBids = await projectBidSubmission.find({ bid_status:'CLOSED', is_bid_winner:true });
        const openProjects = await Project.find({ project_status:'open', deleted:false }).count();
        const closedProjects = await Project.find({ project_status:'close', deleted:false }).count();
        const totalProjects = await Project.find({ deleted:false }).count();

        const projectSummary = {
            'totalProjects': totalProjects,
            'openProjects': openProjects,
            'closedProjects': closedProjects
        }


        return response.successResponse(res, 200, {totalActiveBids:totalActiveBids, winningBids:winningBids , projectSummary: projectSummary}, "");

    } catch (error) {
        console.log("error", error)
        return response.somethingErrorMsgResponse(res, 500, error);
    }
  };


// Get all Dashboard Data for OWNER dashboard
const getOwnerDashboardData = async (req, res) => {
    try {
        const authHeader = req.headers.authorization;
        let token = authHeader.split("Bearer ")[1];
        const loggedInuser = await getLoggedInUser(token);
        
        const myProjects = await Project.find({ deleted:false , ownerId: loggedInuser.payload._id });
        const projectIds = [];
        await myProjects.forEach(project => {
            projectIds.push(project._id);
        });
        const totalActiveBids = await Bid.find({ deleted:false , project_Id: { $in: projectIds } }).count();
        return response.successResponse(res, 200, {totalActiveBids:totalActiveBids}, "");

    } catch (error) {
        console.log("error", error)
        return response.somethingErrorMsgResponse(res, 500, error);
    }
  };

  // Get all Dashboard Data for Manufacturer dashboard
const getManufacturerDashboardData = async (req, res) => {
    try {
        const authHeader = req.headers.authorization;
        let token = authHeader.split("Bearer ")[1];
        const loggedInuser = await getLoggedInUser(token);
        // const manufacturerDetails = await db.getItemByParams(User,{ role:"MANUFACTURER" , _id: loggedInuser.payload._id});
        const manufacturerDetails = await User.findOne({ deleted:false , _id: loggedInuser.payload._id});
        if(manufacturerDetails){
            const buildingsInMyLocation = await Building.find({ deleted:false , state: manufacturerDetails.state });
            const buildingIds = [];
            await buildingsInMyLocation.forEach(building => {
                buildingIds.push(building._id);
            });

            const myProjects = await Project.find({ deleted:false , buildingId: { $in: buildingIds } });
            const myOpenProjects = await Project.find({ deleted:false , project_status:"open", buildingId: { $in: buildingIds } }).count();
            const myClosedProjects = await Project.find({ deleted:false , project_status:"close", buildingId: { $in: buildingIds } }).count();
            
            const projectIds = [];
            await myProjects.forEach(project => {
                projectIds.push(project._id);
            });
            const totalActiveBids = await Bid.find({ deleted:false , project_Id: { $in: projectIds } }).count();
            return response.successResponse(res, 200, {totalActiveBids:totalActiveBids , totalProjects:myProjects.length , openProjects:myOpenProjects , closedProjects:myClosedProjects}, "");

        }else{
            return response.somethingErrorMsgResponse(res, 500, "User details not found");
        }

    } catch (error) {
        console.log("error", error)
        return response.somethingErrorMsgResponse(res, 500, error);
    }
  };

module.exports = {
    getDashboardData,
    getOwnerDashboardData,
    getManufacturerDashboardData
}
