const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { ConvensionalBid } = require("../../models");
const { emailStatus } = require("../../utils/getUser");
const db = require("../../services/db");

/**
 * @description create bid offline by RPC Manager
 * @param {Object} req - request object
 */
const create = async (req, res) => {
    const { first_name, last_name, email, phone, city, state, country, zip_code, company_name, project_Id, address1, address2, } = req.body;
    let MailExist = await emailStatus(email);
    // if mail exist then return message
    if (MailExist) {
        return response.somethingErrorMsgResponse(res, 403, MESSAGE.EMAIL_ALREADY_REGISTERED);
    }
    const bid = new ConvensionalBid({
        first_name,
        last_name,
        email,
        phone,
        city,
        state,
        country,
        zip_code,
        address1,
        address2,
        company_name,
        project_Id
    });
    try {
        const saveBid = await bid.save();
        return response.successResponse(res, 200, saveBid, MESSAGE.BID_SUCCESS);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}


/**
 * Update a bid in database by id
 * @param {string} id - item id
 * @param {Object} req - request object
 */
 const update = async (req, res) => {
    const { first_name, last_name, email, phone, city, state, country, zip_code, company_name, project_Id, address1, address2, } = req.body;
    try {
        var result = await ConvensionalBid.findByIdAndUpdate(
            (_id = req.body._id),
            {
                first_name,
                last_name,
                email,
                phone,
                city,
                state,
                country,
                zip_code,
                address1,
                address2,
                company_name,
                project_Id
            }
        );
        if (result) {
            return response.successResponse(res, 200, result, MESSAGE.BID_UPDATE_SUCCESS);
        } else {
            return response.badRequest(res, 400, MESSAGE.BID_NOT_FOUND);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* Get All bid from database
* @param {string} role - user role
*/
const getAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        req.populate = [{ path: 'project_Id', populate: [{ path: 'media' }], match: { deleted: false } }]
        return response.successResponse(res, 200, await db.getItems(req, ConvensionalBid, query), MESSAGE.BID_LIST);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}

/**
* Get one Contractor from database by id
* @param {string} id - user id
*/
const getOne = async (req, res) => {
    const id = req.query.id;
    try {
        const bid = await ConvensionalBid.findOne({ _id: id }).exec();
        return response.successResponse(res, 200, bid);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

/**
* Delete one Bid from database by id
* @param {string} id - id
*/
const deleteBid = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, ConvensionalBid)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.BID_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
}

module.exports = {
    create,
    getAll,
    update,
    getOne,
    deleteBid
};
