const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { BuildingType } = require("../../models");
const db = require("../../services/db");

/**
* Creates a new BuildingType in database
* @param {Object} req - request object
*/
const add = async (req, res) => {
    const { building_type_name, description } = req.body;

    const buildingType = new BuildingType({
        building_type_name,
        description
    });
    try {
        const saveBuildingType = await buildingType.save();
        return response.successResponse(
            res,
            200,
            saveBuildingType,
            MESSAGE.BUILDING_TYPE_ADD_SUCCESS
        );
    } catch (e) {
        console.log(e);
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const update = async (req, res) => {
    const { building_type_name, description } = req.body;

    try {
        var result = await BuildingType.findByIdAndUpdate(
            (_id = req.body._id),
            {
                building_type_name,
                description,
                updatedBy: req.id,
            },
            {new:true}
        );

        if (result) {
            return response.successResponse(
                res,
                200,
                result,
                MESSAGE.BUILDING_TYPE_UPDATE_SUCCESS
            );
        } else {
            return response.badRequest(res, 400, MESSAGE.BUILDING_TYPE_NOT_FOUND);
        }
    } catch (e) {
        console.log(e);
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

/**
* Get All Material from database by role
* @param {string} req - object
*/
const viewAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        return response.successResponse(res, 200, await db.getItems(req, BuildingType, query), MESSAGE.BUILDING_TYPE_VIEW_DATA);
    } catch (error) {
        console.log(error);
        return response.somethingErrorMsgResponse(res, 500, error);
    }
}
// const viewAll = async (req, res) => {
//     let req_Data = req.body;

//     let { limit, page, ...sortby } = req_Data;

//     var sortName = sortby.sort ? sortby.sort : "createdAt";
//     var sortOption = {};
//     sortOption[`${sortName}`] =
//         sortby.order && sortby.order == 1 ? sortby.order : -1;

//     try {
//         const building_data = await BuildingType.paginate(
//             { deleted: "false" },
//             { page: page || 1, limit: limit || 10, sort: sortOption }
//         );
//         if (building_data) {
//             return response.successResponse(
//                 res,
//                 200,
//                 building_data,
//                 MESSAGE.BUILDING_TYPE_VIEW_DATA
//             );
//         } else {
//             return response.badRequest(res, 400, MESSAGE.BUILDING_TYPE_NOT_FOUND);
//         }
//     } catch (error) {
//         return response.somethingErrorMsgResponse(res, 500, error);
//     }
// };

const deleteBuildingType = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, BuildingType)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.BUILDING_TYPE_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

const viewBuildingType = async (req, res) => {
    const BUILDING_ID = req.query.id;
    try {
      const buildingType = await BuildingType.findOne({ _id: BUILDING_ID }).exec();
      return response.successResponse(res, 200, buildingType);
    } catch (e) {
      return response.somethingErrorMsgResponse(res, 500, e);
    }
  };


// const updateBuildingTypestatus = (req, res) => {
//     const BUILDING_ID = req.body.id;
//     BuildingType.findOne({ _id: BUILDING_ID }, function (err, result) {
//       result.status = !result.status;
//       result.save(function (err, updatedBuildingType) {
//         if (!err) {
//           return response.successResponse(
//             res,
//             200,
//             { status: updatedBuildingType.status },
//             MESSAGE.BUILDING_TYPE_STATUS_UPDATED
//           );
//         } else {
//           return response.somethingErrorMsgResponse(res, 500, error);
//         }
//       });
//     });
//   };
  /**
* toggle change for New Roof type from database by id
* @param {string} id - New Roof type id
*/
const updateBuildingTypestatus = (req, res) => {
    const building_type_id = req.body.id;
    BuildingType.findOne({ _id: building_type_id }, (err, building_type) => {
        building_type.status = !building_type.status;
        building_type.save((err, updatedNewRoofType) => {
            if (!err) {
                return response.successResponse(res, 200, { status: building_type.status }, MESSAGE.BUILDING_TYPE_STATUS_UPDATED);
            } else {
                return response.somethingErrorMsgResponse(res, 500, error);
            }
        });
    });
};

module.exports = {
    viewAll,
    add,
    update,
    deleteBuildingType,
    updateBuildingTypestatus,
    viewBuildingType
}