const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { ApplicationSetting } = require("../../models");
const db = require("../../services/db");
const slugify = require("slugify");

// Create and Save a application Menu
const create = (req, res) => {
    // Validate request
    if (!req.body.menu_title) {
        return response.errorMessageResponse(res, 500, MESSAGE.MENU_TITLE_REQUIRED);
    }
    // let results = await db.insertItem(ApplicationSetting, rerq.body)
    // Create a menu payload
    const menuItem = new ApplicationSetting({
        menu_title: req.body.menu_title, // Menu name 
        type: req.body.type, // textarea, boolean,range, dropdown, multi-dropdown
        key: slugify((req.body.menu_title).toLowerCase()), // unique text string identifier for a single menu item
        description: req.body.description, // description of a menu item
        status: req.body.status, // for menu Active or Deactive
        defaultValue: req.body.defaultValue, // Will have value only for type TextArea
        options: req.body.options ? req.body.options : [], // will be use to hold values of type single select & multiple select dropdown options.
        min_value: req.body.min_value ? req.body.min_value : 0,  // will only have values when type is range
        max_value: req.body.max_value ? req.body.max_value : 0,
    });

    // Save menu in the database
    menuItem.save()
        .then(data => {
            return response.successResponse(res, 200, data, MESSAGE.MENU_ADD_SUCCESS);
        }).catch(err => {
            return response.errorMessageResponse(res, 500, err);
        });
};

// Retrieve and return all application settings Menus from the database.
const findAll = async (req, res) => {
    try {
        let query = await db.checkQueryString(req.query)
        const menusData = await ApplicationSetting.find({deleted:false});
        return response.successResponse(res, 200, menusData, MESSAGE.MENU_GET_DATA);

        // return response.successResponse(res, 200, await db.getItems(req, ApplicationSetting, query), MESSAGE.MENU_GET_DATA);
    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
};

// Find a single Menu Item with a id
const findOne = async (req, res) => {
    try {
        const menuItem = await db.getItemByParams(ApplicationSetting, { _id: req.params.id });
        return response.successResponse(res, 200, page, MESSAGE.MENU_VIEW_DATA);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

// Update single Menu details
const update = async (req, res) => {
    // Validate request
    if (!req.body.menu_title) {
        return response.errorMessageResponse(res, 500, MESSAGE.MENU_TITLE_REQUIRED);
    }
    // Validate if Menu already exist in our database with same name
    const isMenuExist = await ApplicationSetting.findOne({ 'menu_title': req.body.menu_title, _id: { $ne: req.body._id } });
    if (isMenuExist) {
        return response.errorMessageResponse(res, 500, req.body.menu_title + MESSAGE.MENU_ALREADY_EXIST);
    }
    // Create a menu payload
    const payload = {
        menu_title: req.body.menu_title, // Menu name 
        type: req.body.type, // textarea, boolean,range, dropdown, multi-dropdown
        key: slugify((req.body.menu_title).toLowerCase()), // unique text string identifier for a single menu item
        description: req.body.description, // description of a menu item
        status: req.body.status, // for menu Active or Deactive
        defaultValue: req.body.defaultValue, // Will have value only for type TextArea
        options: req.body.options ? req.body.options : [], // will be use to hold values of type single select & multiple select dropdown options.
        min_value: req.body.min_value ? req.body.min_value : 0,  // will only have values when type is range
        max_value: req.body.max_value ? req.body.max_value : 0,
    };
    let results = await db.updateItem(req.body._id, ApplicationSetting, payload)

    if (results) {
        return response.successResponse(res, 200, results, MESSAGE.MENU_UPDATE_SUCCESS);
    } else {
        return response.badRequest(res, 400, MESSAGE.MENU_UPDATE_FAILURE);
    }
};

const deleteMenu = async (req, res) => {
    try {
        const result = await db.softDeleteItems(req.params.id, ApplicationSetting)
        if (result) {
            return response.successResponse(res, 200, {}, MESSAGE.MENU_DELETE_SUCCESS);
        } else {
            return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
        }
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

module.exports = {
    create,
    findAll,
    findOne,
    update,
    deleteMenu
}
