const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { RValue } = require("../../models");
const db = require("../../services/db");

// const getAll_RPC = async (req, res) => {};

const addRValue = async (req, res) => {
  const { r_value_name, description, status } = req.body;

  const rvalue = new RValue({
    r_value_name,
    description,
    status,
  });
  try {
    const saveRvalue = await rvalue.save();
    return response.successResponse(
      res,
      200,
      saveRvalue,
      MESSAGE.RVALUE_ADD_SUCCESS
    );
  } catch (e) {
    console.log(e);
    return response.somethingErrorMsgResponse(res, 500, e);
  }
};

const deleteRValue = async (req, res) => {
  try {
    const result = await db.softDeleteItems(req.params.id, RValue)
    if (result) {
      return response.successResponse(res, 200, {}, MESSAGE.RVALUE_DELETE_SUCCESS);
    } else {
      return response.somethingErrorMsgResponse(res, 500, MESSAGE.SOMETHING_WENT_WRONG);
    }
  } catch (e) {
    return response.somethingErrorMsgResponse(res, 500, e);
  }
  // try {
  //   let id = req.query.id;
  //   RValue.findByIdAndUpdate(
  //     id,
  //     { $set: { deleted: true, updatedBy: req.id } },
  //     { new: true },

  //     function (err) {
  //       if (err) {
  //         return response.somethingErrorMsgResponse(
  //           res,
  //           500,
  //           MESSAGE.SOMETHING_WENT_WRONG
  //         );
  //       } else {
  //         return response.successResponse(
  //           res,
  //           200,
  //           {},
  //           MESSAGE.RVALUE_DELETE_SUCCESS
  //         );
  //       }
  //     }
  //   );
  // } catch (e) {
  //   return response.somethingErrorMsgResponse(
  //     e,
  //     500,
  //     MESSAGE.SOMETHING_WENT_WRONG
  //   );
  // }
};

/**
* Get All Material from database by role
* @param {string} req - object
*/
const viewAllRValue = async (req, res) => {
  try {
      let query = await db.checkQueryString(req.query)
      return response.successResponse(res, 200, await db.getItems(req, RValue, query), MESSAGE.RVALUE_VIEW_DATA);
  } catch (error) {
      console.log(error);
      return response.somethingErrorMsgResponse(res, 500, error);
  }
}
// const viewAllRValue = async (req, res) => {
//   let req_Data = req.body;

//   let { limit, page, ...sortby } = req_Data;

//   var sortName = sortby.sort ? sortby.sort : "createdAt";
//   var sortOption = {};
//   sortOption[`${sortName}`] =
//     sortby.order && sortby.order == 1 ? sortby.order : -1;

//   try {
//     const owner_data = await RValue.paginate(
//       { deleted: "false" },
//       { page: page || 1, limit: limit || 10, sort: sortOption }
//     );
//     if (owner_data) {
//       return response.successResponse(
//         res,
//         200,
//         owner_data,
//         MESSAGE.RVALUE_VIEW_DATA
//       );
//     } else {
//       return response.badRequest(res, 400, MESSAGE.OWNER_NOT_FOUND);
//     }
//   } catch (error) {
//     return response.somethingErrorMsgResponse(res, 500, error);
//   }
// };

const updateRValue = async (req, res) => {
  const { r_value_name, description } = req.body;

  try {
    var result = await RValue.findByIdAndUpdate(
      (_id = req.body._id),
      {
        r_value_name,
        description,
        updatedBy: req.id,
      }
    );

    if (result) {
      return response.successResponse(
        res,
        200,
        result,
        MESSAGE.RVALUE_UPDATE_SUCCESS
      );
    } else {
      return response.badRequest(res, 400, MESSAGE.OWNER_NOT_FOUND);
    }
  } catch (e) {
    return response.somethingErrorMsgResponse(res, 500, e);
  }
};

const viewRvalue = async (req, res) => {
  const USER_ID = req.query.id;
  try {
    const user = await RValue.findOne({ _id: USER_ID }).exec();
    return response.successResponse(res, 200, user);
  } catch (e) {
    return response.somethingErrorMsgResponse(res, 500, e);
  }
};

const updateRvaluestatus = (req, res) => {
  const RVaule_ID = req.body.id;
  RValue.findOne({ _id: RVaule_ID }, function (err, result) {
    result.status = !result.status;
    result.save(function (err, updatedRvalue) {
      if (!err) {
        return response.successResponse(
          res,
          200,
          { status: updatedRvalue.status },
          MESSAGE.RVALUE_STATUS_UPDATED
        );
      } else {
        return response.somethingErrorMsgResponse(res, 500, error);
      }
    });
  });
};

module.exports = {
  addRValue,
  deleteRValue,
  updateRValue,
  viewAllRValue,
  viewRvalue,
  updateRvaluestatus,
};
