const { check, validationResult } = require("express-validator");
const message = require("../../constants/message");
const response = require("../../constants/response");

/**
 * Validates create new RPC request
 */
exports.addRvalue = [
  check("r_value_name")
    .exists()
    .withMessage("MISSING")
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY),
  check("description")
    .exists()
    .withMessage("MISSING")
    .not()
    .isEmpty()
    .withMessage(message.IS_EMPTY),
  (req, res, next) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return response.errorMessageResponse(res, 406, errors.array());
    } else {
      next();
    }
  },
];
