const response = require("../../constants/response");
const MESSAGE = require("../../constants/message");
const { CMSPages} = require("../../models");
const db = require("../../services/db");
const slugify = require("slugify");
const mediaUtils = require("../../utils/unlinkMedia");

// Create and Save a new Page
const create = (req, res) => {
    let media = [];
    const mediaRootPath = "public/uploads/cms/banner_images/";
    const mediaKey = Object.keys(req.files);
    mediaKey.forEach(async key => {
        if (req.files[key].length && req.files[key].length > 0) {
            // multiple files
            const bannerImagesArr = req.files[key];
            await bannerImagesArr.forEach(async mediaFile => {
                media.push({ 
                    path: mediaRootPath +  mediaFile.filename, 
                    filename: mediaFile.filename
                });
            })

        } else {
            console.log("Else condition block")
        }
    })
    // Validate request
    if (!req.body.page_title ) {
        media.forEach(element => {
            mediaUtils.unlink(element.path);
        });
        return response.errorMessageResponse(res, 500, MESSAGE.PAGE_TITLE_REQUIRED);
      }
    if(req.body.type && req.body.type === 'BLOCK_CONTENT'){
        if (!req.body.blocks) {
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return response.badRequest(res, 400, MESSAGE.PAGE_BLOCK_CONTENT_REQUIRED);
          }
          if (req.body.blocks && req.body.blocks.length == 0) {
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return response.badRequest(res, 400, MESSAGE.EMPTY_BLOCK_CONTENT_ERROR);
          }
    }


    // Create a Page
    const page = new CMSPages({
        page_title: req.body.page_title , 
        page_content: req.body.page_content || '',
        slug: slugify((req.body.page_title).toLowerCase()),
        blocks: req.body.blocks && req.body.type === 'BLOCK_CONTENT' ? JSON.parse(req.body.blocks) : [],
        type: req.body.type || 'NORMAL_CONTENT',
        banner_images : media,
        banner_heading: req.body.banner_heading || '',
        banner_description: req.body.banner_description || ''
    });

    // Save Page in the database
    page.save()
    .then(data => {
        return response.successResponse(res, 200, data, MESSAGE.PAGE_ADD_SUCCESS);
    }).catch(err => {
        media.forEach(element => {
            mediaUtils.unlink(element.path);
        });
        return response.errorMessageResponse(res, 500, err);
    });
};

// Retrieve and return all pages from the database.
const findAll = async (req, res) => {
    try {
        const page = await CMSPages.find({}).sort([["updatedAt",-1]]);
        return response.successResponse(res, 200, await db.getItems(req, CMSPages), MESSAGE.PAGE_GET_DATA);

    } catch (error) {
        return response.somethingErrorMsgResponse(res, 500, error);
    }
  };

// Find a single page with a id
const findOne = async (req, res) => {
    try {
        const page = await db.getItemByParams(CMSPages, {_id:req.params.id});
        return response.successResponse(res, 200, page, MESSAGE.PAGE_VIEW_DATA);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

// Find a single page with a slug
const findPageBySlug = async(req, res) => {
    try {
        const page = await db.getItemByParams(CMSPages, {slug:req.params.slug});
        return response.successResponse(res, 200, page, MESSAGE.PAGE_VIEW_DATA);
    } catch (e) {
        return response.somethingErrorMsgResponse(res, 500, e);
    }
};

// Update page details
const update = async (req, res) => {
    let media = [];
    const mediaRootPath = "public/uploads/cms/banner_images/";
    const mediaKey = Object.keys(req.files);
    mediaKey.forEach(async key => {
        if (req.files[key].length && req.files[key].length > 0) {
            // multiple files
            const bannerImagesArr = req.files[key];
            await bannerImagesArr.forEach(async mediaFile => {
                media.push({ 
                    path: mediaRootPath +  mediaFile.filename, 
                    filename: mediaFile.filename
                });
            })

        } else {
            console.log("Else condition block")
        }
    })
    // Validate request
    if (!req.body.page_title ) {
        media.forEach(element => {
            mediaUtils.unlink(element.path);
        });
        return response.errorMessageResponse(res, 500, MESSAGE.PAGE_TITLE_REQUIRED);
      }
    if(req.body.type && req.body.type === 'BLOCK_CONTENT'){
        if (!req.body.blocks) {
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return response.badRequest(res, 400, MESSAGE.PAGE_BLOCK_CONTENT_REQUIRED);
          }
          if (req.body.blocks && req.body.blocks.length == 0) {
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return response.badRequest(res, 400, MESSAGE.EMPTY_BLOCK_CONTENT_ERROR);
          }
    }
    const payload = {
        page_content: req.body.page_content || '',
        blocks: req.body.blocks && req.body.type === 'BLOCK_CONTENT' ? JSON.parse(req.body.blocks) : [],
        type: req.body.type || 'NORMAL_CONTENT',
        banner_images : req.body.existing_images && req.body.existing_images.length >0 ? [...JSON.parse(req.body.existing_images) , ...media] : media,
        banner_heading: req.body.banner_heading || '',
        banner_description: req.body.banner_description || ''
    }
    let results = await db.updateItem(req.body._id, CMSPages, payload)

    if (results) {
        // Remove all the removed media from directory and Media Collection
        if(req.body.removed_items){
            const filesTobeRemoved = JSON.parse(req.body.removed_items);
            await filesTobeRemoved.forEach(element => {
                mediaUtils.unlink(element.path);
            });
        }
        return response.successResponse(res, 200, results, MESSAGE.PAGE_UPDATE_SUCCESS);
        } else {
        media.forEach(element => {
            mediaUtils.unlink(element.path);
        });
        return response.badRequest(res, 400, MESSAGE.PAGE_UPDATE_FAILURE);
        }
};

module.exports = {
   create,
   findAll,
   findOne,
   findPageBySlug,
   update
}
