var multer = require('multer');
const path = require('path');
const fs = require('fs');
const { _value } = require("../utils/getRandom");
// const { getLoggedInUser } = require("../utils/jwtToken");
const fse = require('fs-extra')

/*
*Upload profile pic
*/
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        // const authHeader = req.headers.authorization;
        // let token = authHeader.split("Bearer ")[1];
        // const loggedInuser = getLoggedInUser(token);
        // console.log("req.body", req.body)
        var dirpath = './public/uploads/';
        switch (file.fieldname) {
            case 'profile_pic':
            {
                dirpath = dirpath + '/profile_picture/'
                break;
            }
            case 'banner_images':
            {
                dirpath = dirpath + '/cms/banner_images/'
                break;
            }
            case 'images':
            case 'roof_drawings':
            case 'standard_contract':
            case 'insurance':
            case 'detail_drawings':
            case 'specifications':
            case 'videos':
            {
                dirpath = dirpath  + '/' + req.body.ownerId + '/buildings/'+ req.body.buildingId + '/projects/' + file.fieldname
                break;
            }
            case 'building_images':
            case 'building_documents':
            case 'building_videos':
            {
                dirpath = dirpath  + '/' + req.body.ownerId + '/buildings/'+ file.fieldname
                break;
            }
            case 'inspection_images':
            case 'inspection_documents':
            case 'inspection_videos':
            {
                dirpath = dirpath  + '/inspections/'+ req.body.projectId + '/'+ file.fieldname
                break;
            }
        }
        // const fileDir = `${path.join(__dirname, dirpath)}`
        // fs.mkdirSync(fileDir, { recursive: true })
        const fileDir = path.resolve(dirpath) 
        fse.ensureDirSync(fileDir); // Make sure that the upload path exits

        cb(null, fileDir);
    },
    filename: function (req, file, cb) {
        cb(null, file.fieldname + '-' + Date.now() + "-" + _value(22) + path.extname(file.originalname));
    }
});
module.exports = {
    storage
}



