const express = require("express");
const cors = require("cors");
const bodyParser = require("body-parser");
const port = process.env.APP_PORT || 9121;
const app = express();
const path = require("path");
const webapi = require("./routes/web");
const adminApi = require("./routes/admin");
const rpcRouter = require("./routes/rpcManager");
const contractRouter = require("./routes/contractor");
const ownerRouter = require("./routes/owner");
const manufacturerRouter = require("./routes/manufacturer");
const moduleRoute = require("./routes/modules");
const permissionRoute = require("./routes/permission");

const sharedRoute = require("./routes/shared"); // router to handle common operations of users.

const { PaymentCtr } = require("./controllers");

const socket = require("./socket");

const http = require('http');
// const WebSocket = require('ws');
//initialize a simple http server
const server = http.createServer(app);

//initialize the WebSocket server instance
// const wss = new WebSocket.Server({ server });
app.set("socketService", new socket(server));

require("./config/db.config");
require("dotenv").config();

// app.use(cors());
app.use(cors({ origin: '*' }));
app.use(express.json({ limit: "50mb" }));

app.use(bodyParser.urlencoded({ limit: "50mb", extended: false }));
// Public directory
// app.use('/static', express.static(__dirname + '/public'));
app.use("/public", express.static("public"));
app.use(bodyParser.json());
app.use(process.env.API_PREFIX, webapi);
app.use(process.env.ADMIN_API_PREFIX, adminApi);
app.use(process.env.RPC_API_PREFIX, rpcRouter);
app.use(process.env.CON_API_PREFIX, contractRouter);
app.use(process.env.OWNER_API_PREFIX, ownerRouter);
app.use(process.env.MANUFACTURER_API_PREFIX, manufacturerRouter);

app.use('/api/v1/module', moduleRoute);
app.use('/permission', permissionRoute);
app.use('/api/v1/user', sharedRoute);

app.get("/", (req, res) => {
  res.send(
    `Roofing Project is Working and running on Port ${port}`
  );
});

app.get("/notify_users", (req, res) => {
  wss.clients.forEach(function each(client) {
    if (client.readyState === WebSocket.OPEN) {     // check if client is ready
      client.send("HOLA separate API endpoint".toString());
    }
  })
  res.send(
    `Roofing Project is Working and running on Port ${port}-----WS clients are: ${wss.clients.length}`
  );
});

// server.js
//
// Use this sample code to handle webhook events in your integration.
//
// 1) Paste this code into a new file (server.js)
//
// 2) Install dependencies
//   npm install stripe
//   npm install express
//
// 3) Run the server on http://localhost:4242
//   node server.js

const stripe = require('stripe')(process.env.STRIPE_SECURITY_KEY);
// const express = require('express');
// const app = express();
let endpointSecret;
// This is your Stripe CLI webhook secret for testing your endpoint locally.
// endpointSecret = "whsec_ebb2e8e61619f2b1a87b60bc96ea0b2ef1622ae13d4c1438bb398537a9db70e0";

// app.post('/webhook', express.raw({ type: 'application/json' }), (request, response) => {
//   const sig = request.headers['stripe-signature'];
//   console.log("webhook end point called")
//   let eventType;
//   let data;
//   if (endpointSecret) {
//     let event;

//     try {
//       event = stripe.webhooks.constructEvent(request.body, sig, endpointSecret);
//       console.log(`Webhook Verified: ${data}`)
//     } catch (err) {
//       console.log(`Webhook Error: ${err.message}`)
//       response.status(400).send(`Webhook Error: ${err.message}`);
//       return;
//     }
//     data = event.data.object;
//     eventType = event.type;
//   } else {
//     data = request.body.data.object;
//     eventType = request.body.type;
//   }


//   // Handle the event
//   switch (eventType) {
//     case 'payment_intent.succeeded':
//       const paymentIntent = data;
//       // Then define and call a function to handle the event payment_intent.succeeded
//       console.log("Payment Intent success:", data)
//       break;
//     case 'checkout.session.completed':
//       // const paymentIntent = event.data.object;
//       // Then define and call a function to handle the event payment_intent.succeeded
//       console.log("Checkout success:", data)
//       break;
//     // ... handle other event types
//     default:
//       console.log(`Unhandled event type ${eventType}`);
//   }

//   // Return a 200 response to acknowledge receipt of the event
//   response.send().end();
// });

app.post('/webhook',express.raw({ type: 'application/json' }), PaymentCtr.onTransactionComplete)


server.listen(port, () => {
  console.log(`Roofing app listening on port ${port}`);
});
